# Perl5 script to make binary search tables for Big5 <-> CNS conversion from rfc1922.

require 5;

$cns_to_big5_h = 'cns%s-to-big5.h' if (!defined($cns_to_big5_h));
$big5_to_cns_h = 'big5-to-cns.h' if (!defined($bit5_to_cns_h));

my @cns_to_big5;
my %big5_to_cns;
my $plane = 0;
my $line;

foreach (1 .. 7) {
  my %hash;

  push(@cns_to_big5, \%hash);
}

while (defined($line = <>)) {
  if ($line =~ /CNS\s.*\sPlane\s*([1-7])/i) {
    $plane = $1 + 0;
  }
  elsif ($plane > 0) {
    if ($line =~ /^\s*(0x[0-9A-Fa-f]+)\s+<->\s+(0x[0-9A-Fa-f]+)/) {
      $big5_to_cns{$1} = [$1, $2, $plane];
      $cns_to_big5[$plane - 1]->{$2} = [$2, $1];
    }
    elsif ($line =~ /^\s*(0x[0-9A-Fa-f]+)-(0x[0-9A-Fa-f]+)\s+<->\s+(0x[0-9A-Fa-f]+)-(0x[0-9A-Fa-f]+)/) {
      $big5_to_cns{$1} = [$2, $3, $plane];
      $cns_to_big5[$plane - 1]->{$3} = [$4, $1];
    }
  }
}

local (*H, *I);

my ($i, $fn, $tab);

$fn = sprintf($cns_to_big5_h, '');
open(H, ">$fn") || die "open(H, \">$fn\"): $!";

for ($i = 1 ; $i <= @cns_to_big5 ; ++$i) {
  $fn = sprintf($cns_to_big5_h, "$i");
  open(I, ">$fn") || die "open(I, \">$fn\"): $!";
  $tab = $cns_to_big5[$i - 1];

  if (%$tab) {
    printf H "#define CNS%d_TO_BIG5\n", $i;

    foreach $beg (sort keys %$tab) {
      printf I "{%s, %s, %s},\n", $beg, @{$tab->{$beg}};
    }
  }
  else {
    printf H "#undef CNS%d_TO_BIG5\n", $i;
  }

  close(I);
}

close(H);
open(H, ">$big5_to_cns_h") || die "open(H, \">$big5_to_cns_h\"): $!";

foreach $beg (sort keys %big5_to_cns) {
  printf H "{%s, %s, %s, %d},\n", $beg, @{$big5_to_cns{$beg}};
}

close(H);
exit;
