#ifndef __ISDS_SOAP_H__
#define __ISDS_SOAP_H__

#include "isds.h"

/* Close connection to server and destroy CURL handle associated
 * with @context */
isds_error _isds_close_connection(struct isds_ctx *context);

/* Do SOAP request.
 * @context holds the base URL,
 * @file is a (CGI) file of SOAP URL,
 * @request is XML node set with SOAP request body. 
 * @file must be NULL, @request should be NULL rather than empty, if they should
 * not be signaled in the SOAP request.
 * @reponse is automatically allocated() node set with SOAP response body.
 * You must xmlFreeNodeList() it. This is literal body, empty (NULL), one node
 * or more nodes can be returned.
 * @raw_response is automatically allocated bit stream with response body. Use
 * NULL if you don't care
 * @raw_response_length is size of @raw_response in bytes
 * In case of error the response will be deallocated automatically.
 * Side effect: message buffer */
isds_error _isds_soap(struct isds_ctx *context, const char *file,
        const xmlNodePtr request, xmlNodePtr *response,
        void **raw_response, size_t *raw_response_length);

/* Build new URL from current @context and template.
 * @context is context carrying an URL
 * @template is printf(3) format string. First argument is string of base URL
 * found in @context, second argument is length of the base URL.
 * @new_url is newly allocated URL built from @template. Caller must free it.
 * Return IE_SUCCESS, or corresponding error code and @new_url will not be
 * allocated.
 * */
isds_error _isds_build_url_from_context(struct isds_ctx *context,
        const char *template, char **new_url);

/* Invalidate session cookie for otp authenticated @context */
isds_error _isds_invalidate_otp_cookie(struct isds_ctx *context);

#endif
