/*******************************************************************************************************************************************
 cspinbutton.c
*******************************************************************************************************************************************/

#include "cspinbutton.h"

//------------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//------------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_GENERIC_METACLASS (CSpinButtonListener);

//------------------------------------------------------------------------------------------------------------------------------------------
// constructor
//------------------------------------------------------------------------------------------------------------------------------------------
CSpinButtonListener::CSpinButtonListener ()
{ }

//------------------------------------------------------------------------------------------------------------------------------------------
// destructor
//------------------------------------------------------------------------------------------------------------------------------------------
CSpinButtonListener::~CSpinButtonListener ()
{ }

//------------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//------------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_DYNAMIC_METACLASS (CSpinButton);

//------------------------------------------------------------------------------------------------------------------------------------------
// OnUpdate
//------------------------------------------------------------------------------------------------------------------------------------------
void CSpinButton::OnUpdate (GtkSpinButton *, gpointer inData)
{
	// retreive the gtkol instance
	CSpinButton *inSpinButton = reinterpret_cast <CSpinButton *> (inData);

	// send the notification to the listener if any
	if (inSpinButton != NULL && inSpinButton -> GetListener() != NULL)
		static_cast <CSpinButtonListener *> (inSpinButton -> GetListener()) -> OnUpdate (inSpinButton);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// constructor
//------------------------------------------------------------------------------------------------------------------------------------------
CSpinButton::CSpinButton (CContainer *inOwner, const CEntryListener *inListener)
	    :CEntry	 (NULL, inListener)
{
	// owner affectation, gtk widget instanciation request
	if (inOwner != NULL) SetOwner (inOwner);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// destructor
//------------------------------------------------------------------------------------------------------------------------------------------
CSpinButton::~CSpinButton ()
{
	// deletion coherence requested
	CWidget::DestroyWidget (this);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// gtk instanciation
//------------------------------------------------------------------------------------------------------------------------------------------
GtkWidget * CSpinButton::PerformWidgetInstanciate ()
{
	// ok (min, max, step, pg inc equal 10 x step)
	return ::gtk_spin_button_new_with_range (0, 10, .1);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// gtk initialization
//------------------------------------------------------------------------------------------------------------------------------------------
void CSpinButton::PerformWidgetInitialize ()
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// specific signal connection
	if (inGtkWidget != NULL)
		::g_signal_connect (G_OBJECT(inGtkWidget), "value-changed", G_CALLBACK(CSpinButton::OnUpdate), this);

	// generic call
	CEntry::PerformWidgetInitialize ();
}

//------------------------------------------------------------------------------------------------------------------------------------------
// expected listener type
//------------------------------------------------------------------------------------------------------------------------------------------
const CMetaClass * CSpinButton::ListenerMustBe () const
{
	return __metaclass(CSpinButtonListener);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// range affectation
//------------------------------------------------------------------------------------------------------------------------------------------
void CSpinButton::SetRange (const double inMin, const double inMax)
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	if (inGtkWidget != NULL) ::gtk_spin_button_set_range (GTK_SPIN_BUTTON(inGtkWidget), inMin, inMax);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// min range
//------------------------------------------------------------------------------------------------------------------------------------------
double CSpinButton::GetMin () const
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL) return 0;

	// retreive the property
	double outMin; ::gtk_spin_button_get_range (GTK_SPIN_BUTTON(inGtkWidget), &outMin, NULL);

	// ok
	return outMin;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// max range
//------------------------------------------------------------------------------------------------------------------------------------------
double CSpinButton::GetMax () const
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL) return 0;

	// retreive the property
	double outMax; ::gtk_spin_button_get_range (GTK_SPIN_BUTTON(inGtkWidget), NULL, &outMax);

	// ok
	return outMax;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// digits affectation
//------------------------------------------------------------------------------------------------------------------------------------------
void CSpinButton::SetDigits (const UInt8 inDigits)
{
	// retreive our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	if (inGtkWidget != NULL) ::gtk_spin_button_set_digits (GTK_SPIN_BUTTON(inGtkWidget), inDigits);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// digits reader
//------------------------------------------------------------------------------------------------------------------------------------------
UInt8 CSpinButton::GetDigits () const
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	return inGtkWidget != NULL ? ::gtk_spin_button_get_digits (GTK_SPIN_BUTTON(inGtkWidget)) : 0;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// increments affectation
//------------------------------------------------------------------------------------------------------------------------------------------
void CSpinButton::SetIncrements (const double inStep, const double inPage)
{
	// get our instance
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	if (inGtkWidget != NULL) ::gtk_spin_button_set_increments (GTK_SPIN_BUTTON(inGtkWidget), inStep, inPage);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// step reader
//------------------------------------------------------------------------------------------------------------------------------------------
double CSpinButton::GetStep () const
{
	// get the gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL) return 0;

	// retreive the property
	double outStep; ::gtk_spin_button_get_increments (GTK_SPIN_BUTTON(inGtkWidget), &outStep, NULL);

	// ok
	return outStep;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// page reader
//------------------------------------------------------------------------------------------------------------------------------------------
double CSpinButton::GetPage () const
{
	// get the gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL) return 0;

	// retreive the property
	double outPage; ::gtk_spin_button_get_increments (GTK_SPIN_BUTTON(inGtkWidget), NULL, &outPage);

	// ok
	return outPage;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// value affectation
//------------------------------------------------------------------------------------------------------------------------------------------
void CSpinButton::SetValue (const double inValue)
{
	// get the gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	if (inGtkWidget != NULL) ::gtk_spin_button_set_value (GTK_SPIN_BUTTON(inGtkWidget), inValue);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// value access
//------------------------------------------------------------------------------------------------------------------------------------------
double CSpinButton::GetValue () const
{
	// get the gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	return inGtkWidget != NULL ? ::gtk_spin_button_get_value (GTK_SPIN_BUTTON(inGtkWidget)) : 0;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// update policy
//------------------------------------------------------------------------------------------------------------------------------------------
void CSpinButton::SetUpdatePolicy (const GtkSpinButtonUpdatePolicy inGtkSpinButtonUpdatePolicy)
{
	// get the gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	if (inGtkWidget != NULL) ::gtk_spin_button_set_update_policy (GTK_SPIN_BUTTON(inGtkWidget), inGtkSpinButtonUpdatePolicy);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// update policy
//------------------------------------------------------------------------------------------------------------------------------------------
GtkSpinButtonUpdatePolicy CSpinButton::GetUpdatePolicy () const
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	return inGtkWidget != NULL ? ::gtk_spin_button_get_update_policy (GTK_SPIN_BUTTON(inGtkWidget)) : GTK_UPDATE_ALWAYS;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// numeric
//------------------------------------------------------------------------------------------------------------------------------------------
void CSpinButton::SetNumeric (const bool inNumeric)
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	if (inGtkWidget != NULL) ::gtk_spin_button_set_numeric (GTK_SPIN_BUTTON(inGtkWidget), inNumeric);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// numeric
//------------------------------------------------------------------------------------------------------------------------------------------
bool CSpinButton::GetNumeric () const
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	return inGtkWidget != NULL ? ::gtk_spin_button_get_numeric (GTK_SPIN_BUTTON(inGtkWidget)) : false;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// spin
//------------------------------------------------------------------------------------------------------------------------------------------
void CSpinButton::Spin (const GtkSpinType inGtkSpinType, const double inInc)
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	if (inGtkWidget != NULL) ::gtk_spin_button_spin (GTK_SPIN_BUTTON(inGtkWidget), inGtkSpinType, inInc);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// wrap
//------------------------------------------------------------------------------------------------------------------------------------------
void CSpinButton::SetWrap (const bool inWrap)
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	if (inGtkWidget != NULL) ::gtk_spin_button_set_wrap (GTK_SPIN_BUTTON(inGtkWidget), inWrap);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// wrap
//------------------------------------------------------------------------------------------------------------------------------------------
bool CSpinButton::GetWrap () const
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	return inGtkWidget != NULL ? ::gtk_spin_button_get_wrap (GTK_SPIN_BUTTON(inGtkWidget)) : false;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// snap
//------------------------------------------------------------------------------------------------------------------------------------------
void CSpinButton::SetSnapToTicks (const bool inSnap)
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	if (inGtkWidget != NULL) ::gtk_spin_button_set_snap_to_ticks (GTK_SPIN_BUTTON(inGtkWidget), inSnap);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// snap
//------------------------------------------------------------------------------------------------------------------------------------------
bool CSpinButton::GetSnapToTicks () const
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	return inGtkWidget != NULL ? ::gtk_spin_button_get_snap_to_ticks (GTK_SPIN_BUTTON(inGtkWidget)) : false;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// update
//------------------------------------------------------------------------------------------------------------------------------------------
void CSpinButton::Update ()
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	::gtk_spin_button_update (GTK_SPIN_BUTTON(inGtkWidget));
}

//------------------------------------------------------------------------------------------------------------------------------------------
// xml serialization
//------------------------------------------------------------------------------------------------------------------------------------------
void CSpinButton::Serialize (CXMLElementNode *&ioXMLElementNode, const int inMode) THROWABLE
{
	// generic call first
	CEntry::Serialize (ioXMLElementNode, inMode);

	// request analyse
	switch (inMode)
	{
		// xml dump
		case XML_WRITE :
		{
			// create a new xml element node for the serialization
			CXMLElement *newXMLElement = new CXMLElement (ioXMLElementNode, XML_SPINBUTTON_ELEMENT);
			
			// add the attributes
			newXMLElement -> AddAttribute (XML_SPINBUTTON_ATTR_VALUE, CString(GetValue()));
			newXMLElement -> AddAttribute (XML_SPINBUTTON_ATTR_MIN, CString(GetMin()));
			newXMLElement -> AddAttribute (XML_SPINBUTTON_ATTR_MAX, CString(GetMax()));
			newXMLElement -> AddAttribute (XML_SPINBUTTON_ATTR_DIGITS, CString((UInt32)GetDigits()));
			newXMLElement -> AddAttribute (XML_SPINBUTTON_ATTR_STEP, CString(GetStep()));
			newXMLElement -> AddAttribute (XML_SPINBUTTON_ATTR_PAGE, CString(GetPage()));
			newXMLElement -> AddAttribute (XML_SPINBUTTON_ATTR_UPDATE, CString(GetUpdatePolicy()==GTK_UPDATE_IF_VALID ? 
						       "if-valid":"always"));
			newXMLElement -> AddAttribute (XML_SPINBUTTON_ATTR_NUMERIC, CString(GetNumeric()?"true":"false"));
			newXMLElement -> AddAttribute (XML_SPINBUTTON_ATTR_WRAP, CString(GetWrap()?"true":"false"));
			newXMLElement -> AddAttribute (XML_SPINBUTTON_ATTR_SNAP, CString(GetSnapToTicks()?"true":"false"));

			// modify the io xml element node so that the potential overloaded definitions will continue under the current node
			ioXMLElementNode = newXMLElement -> GetXMLElementNode ();
		}
		break;

		// xml load
		case XML_READ :
		{
			// get the child node this serialization process is interested in
			CXMLElementNode *inXMLNode = ::xml_node_get_child (ioXMLElementNode, XML_SPINBUTTON_ELEMENT);

			// check we got an expected cbutton node
			if (inXMLNode == NULL)
				throw new CException (CString("CSpinButton::Serialize, specified xml node is not a \"") + 
							      XML_SPINBUTTON_ELEMENT + CString("\" element one."), __exception(XMLPARSE));

			// modify the in/out element node pointer so that the serialization process will continue under the current node
			ioXMLElementNode = inXMLNode;

			// set the spin button properties
			SetRange        (::xml_node_get_attribute (inXMLNode, XML_SPINBUTTON_ATTR_MIN).GetValue().ToDouble(), 
				         ::xml_node_get_attribute (inXMLNode, XML_SPINBUTTON_ATTR_MAX).GetValue().ToDouble());
			SetDigits       (::xml_node_get_attribute (inXMLNode, XML_SPINBUTTON_ATTR_DIGITS).GetValue().ToULong());
			SetIncrements   (::xml_node_get_attribute (inXMLNode, XML_SPINBUTTON_ATTR_STEP).GetValue().ToDouble(),
				         ::xml_node_get_attribute (inXMLNode, XML_SPINBUTTON_ATTR_PAGE).GetValue().ToDouble());
			SetUpdatePolicy (::xml_node_get_attribute (inXMLNode, XML_SPINBUTTON_ATTR_UPDATE).GetValue() == 
					 CString("if-valid") ? GTK_UPDATE_IF_VALID : GTK_UPDATE_ALWAYS);
			SetNumeric	(::xml_node_get_attribute (inXMLNode, XML_SPINBUTTON_ATTR_NUMERIC).GetValue().ToBool());
			SetWrap		(::xml_node_get_attribute (inXMLNode, XML_SPINBUTTON_ATTR_WRAP).GetValue().ToBool());
			SetSnapToTicks  (::xml_node_get_attribute (inXMLNode, XML_SPINBUTTON_ATTR_SNAP).GetValue().ToBool());
			SetValue        (::xml_node_get_attribute (inXMLNode, XML_SPINBUTTON_ATTR_VALUE).GetValue().ToDouble());
		}
		break;
	}
}

