/*******************************************************************************************************************************************
 cradiobutton.c
*******************************************************************************************************************************************/

#include "cradiobutton.h"
//#include "cseparator.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// metaclass 
//-----------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_DYNAMIC_METACLASS (CRadioButton);

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CRadioButton::CRadioButton (CContainer *inOwner, const CButtonListener *inListener)
	     :CCheckButton (NULL, inListener)
{
	// launch the widget instanciation process
	if (inOwner != NULL) SetOwner (inOwner);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// destructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CRadioButton::~CRadioButton ()
{
	// deletion coherence requested
	CWidget::DestroyWidget (this);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// gtk widget specific instanciation
//-----------------------------------------------------------------------------------------------------------------------------------------
GtkWidget * CRadioButton::PerformWidgetInstanciate ()
{
	// ok
	return ::gtk_radio_button_new (NULL);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// owner affectation
//-----------------------------------------------------------------------------------------------------------------------------------------
bool CRadioButton::SetOwner (CComponent *inOwner, const SInt16 inIndex)
{
	// generic call first
	if (!CCheckButton::SetOwner (inOwner, inIndex)) return false;



	// TODO... separator handling to logicaly define radio groups according to gui view



	// get our siblings
	CComponents inSiblings (GetSiblings (__metaclass(CRadioButton)) - this);

	// the radio group our gtk instance must be attached to
	GSList *inRadioGroup = NULL;

	// get the radio group if there is at least one radio button yet
	if (inSiblings.GetLength() > 0) 
		inRadioGroup = ::gtk_radio_button_get_group (GTK_RADIO_BUTTON(static_cast <CWidget *> (*inSiblings[0]) -> GetGtkWidget()));

	// group affectation
	::gtk_radio_button_set_group (GTK_RADIO_BUTTON(GetGtkWidget()), inRadioGroup);

	// ok
	return true;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// check 
//-----------------------------------------------------------------------------------------------------------------------------------------
void CRadioButton::Check (const bool inCheck)
{
	// check gtk pointer
	if (GetGtkWidget() == NULL) return;
	
	// our owner
	CComponent *inOwner = GetOwner ();

	// be paranoïd...
	if (inOwner == NULL) return;

	// get our siblings
	CComponents inRadioButtons (GetSiblings (__metaclass(CRadioButton)));

	// all the click signals are disconnected
	for (size_t i=0; i<inRadioButtons.GetLength(); i++)
		::g_signal_handlers_disconnect_by_func 
			(G_OBJECT(static_cast <CRadioButton *> (*inRadioButtons[i]) -> GetGtkWidget()), 
				(void*)G_CALLBACK(CToggleButton::OnClick), this);

	// gui gtk property affectation
	::gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(GetGtkWidget()), inCheck);

	// all signals are connected again
	for (size_t i=0; i<inRadioButtons.GetLength(); i++)
		::g_signal_connect 
			(G_OBJECT(static_cast <CRadioButton *> (*inRadioButtons[i]) -> GetGtkWidget()), 
			 	"toggled", G_CALLBACK(CToggleButton::OnClick), this);
}

