/******************************************************************************************************************************************
 citemfieldvalue.c
******************************************************************************************************************************************/

#include "citemfieldvalue.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// CItemFieldValue
//-----------------------------------------------------------------------------------------------------------------------------------------

RESOLVE_GENERIC_METACLASS (CItemFieldValueAPIListener);

CItemFieldValueAPIListener::CItemFieldValueAPIListener ()
{ }

CItemFieldValueAPIListener::~CItemFieldValueAPIListener ()
{ }

RESOLVE_GENERIC_METACLASS (CItemFieldValue);

CItemFieldValue::CItemFieldValue (const bool inVisible)
		:CObject	 (NULL),
		 m_Owner	 (NULL),
		 m_Visible	 (inVisible)
{ 
	m_SerializeListener = false;
}

CItemFieldValue::~CItemFieldValue ()
{ }

static CString XML_CITEMFIELDVALUE_ELEMENT	("citemfieldvalue");
static CString XML_CITEMFIELDVALUE_ATTR_VISIBLE	("visible");

const CMetaClass * CItemFieldValue::ListenerMustBe () const
{
	return __metaclass(CItemFieldValueAPIListener);
}

CObject * CItemFieldValue::GetOwner () const
{
	return const_cast <CObject *> (m_Owner);
}

void CItemFieldValue::SetVisible (const bool inVisible)
{
	m_Visible = inVisible;
	if (m_Listener != NULL) static_cast <CItemFieldValueAPIListener *> (m_Listener) -> OnStateChange (this);
}

bool CItemFieldValue::GetVisible () const
{
	return m_Visible;
}

CItemFieldValue & CItemFieldValue::operator = (const CString &)
{
	return *this; 
}

CItemFieldValue & CItemFieldValue::operator = (const CItemFieldValueString &)
{
	return *this; 
}

CItemFieldValue & CItemFieldValue::operator = (const bool inVisible)
{
	SetVisible (inVisible);
	return *this;
}

CItemFieldValue & CItemFieldValue::operator = (const CItemFieldValueBoolean &inVisible)
{
	SetVisible (inVisible.m_Visible);
	return *this;
}

CItemFieldValue & CItemFieldValue::operator = (const float)
{
	return *this; 
}

CItemFieldValue & CItemFieldValue::operator = (const CItemFieldValueProgress &)
{
	return *this;
}

CItemFieldValue & CItemFieldValue::operator = (const CPixbuf *)
{
	return *this; 
}

bool operator ! (const CItemFieldValue &inFieldValue)
{
	if (inFieldValue.ClassIs (__metaclass(CItemFieldValueBoolean)))
		return !static_cast <const CItemFieldValueBoolean &> (inFieldValue).GetFieldValue();
	return false;
}

void CItemFieldValue::Serialize (CXMLElementNode *&ioXMLElementNode, const int inMode) THROWABLE
{
	CObject::Serialize (ioXMLElementNode, inMode);
	switch (inMode)
	{
		case XML_WRITE :
		{
			CXMLElement *newXMLElement = new CXMLElement (ioXMLElementNode, XML_CITEMFIELDVALUE_ELEMENT);
			newXMLElement -> AddAttribute (XML_CITEMFIELDVALUE_ATTR_VISIBLE, CString(m_Visible ? "true" : "false"));
			ioXMLElementNode = newXMLElement -> GetXMLElementNode ();
		}
		break;
		case XML_READ :
		{
			CXMLElementNode *inXMLNode = ::xml_node_get_child (ioXMLElementNode, XML_CITEMFIELDVALUE_ELEMENT);
                        if (inXMLNode == NULL)
                                throw new CException (CString("CItemFieldValue::Serialize, specified xml node is not a \"") +
                                                              XML_CITEMFIELDVALUE_ELEMENT + CString("\" element one."), 
						      	      __exception(XMLPARSE));
			m_Visible = ::xml_node_get_attribute (inXMLNode, XML_CITEMFIELDVALUE_ATTR_VISIBLE).GetValue().ToBool();
			ioXMLElementNode = inXMLNode;
		}
		break;
	}
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// CItemFieldValuePack
//-----------------------------------------------------------------------------------------------------------------------------------------

RESOLVE_GENERIC_METACLASS (CItemFieldValuePack);

CItemFieldValuePack::CItemFieldValuePack ()
{ }

CItemFieldValuePack::~CItemFieldValuePack ()
{ }

//-----------------------------------------------------------------------------------------------------------------------------------------
// CItemFieldValueString
//-----------------------------------------------------------------------------------------------------------------------------------------

RESOLVE_DYNAMIC_METACLASS (CItemFieldValueString);

CItemFieldValueString::CItemFieldValueString (const CString &inFieldValue, const bool inEnabled, const bool inVisible)
		      :CItemFieldValue	     (inVisible),
		       m_Enabled	     (inEnabled),
		       m_FieldValue	     (inFieldValue)
{ }

CItemFieldValueString::~CItemFieldValueString ()
{ }

static CString XML_CITEMFIELDVALUESTRING_ELEMENT	("citemfieldvaluestring");
static CString XML_CITEMFIELDVALUESTRING_ATTR_EDITABLE	("editable");

void CItemFieldValueString::SetEnabled (const bool inEnabled)
{
	m_Enabled = inEnabled;
	if (m_Listener != NULL) static_cast <CItemFieldValueAPIListener *> (m_Listener) -> OnStateChange (this);
}

bool CItemFieldValueString::GetEnabled () const
{
	return m_Enabled;
}

void CItemFieldValueString::SetFieldValue (const CString &inFieldValue)
{
	m_FieldValue = inFieldValue;
	if (m_Listener != NULL) static_cast <CItemFieldValueAPIListener *> (m_Listener) -> OnStateChange (this);
}

CString CItemFieldValueString::GetFieldValue () const
{
	return m_FieldValue;
}

CItemFieldValue & CItemFieldValueString::operator = (const CString &inFieldValue)
{
	SetFieldValue (inFieldValue);
	return *this;
}

CItemFieldValue & CItemFieldValueString::operator = (const CItemFieldValueString &inFieldValue)
{
	m_FieldValue = inFieldValue.m_FieldValue;
	m_Enabled    = inFieldValue.m_Enabled;
	if (m_Listener != NULL) static_cast <CItemFieldValueAPIListener *> (m_Listener) -> OnStateChange (this);
	return *this;
}

CItemFieldValue & CItemFieldValueString::operator = (const bool inEnabled)
{
	SetEnabled (inEnabled);
	return *this;
}

CItemFieldValue & CItemFieldValueString::operator = (const CItemFieldValueBoolean &inEnabled)
{
	SetEnabled (inEnabled.GetFieldValue());
	return *this;
}

void CItemFieldValueString::Serialize (CXMLElementNode *&ioXMLElementNode, const int inMode) THROWABLE
{
	CItemFieldValue::Serialize (ioXMLElementNode, inMode);
	switch (inMode)
	{
		case XML_WRITE :
		{
			CXMLElement *newXMLElement = new CXMLElement (ioXMLElementNode, XML_CITEMFIELDVALUESTRING_ELEMENT, m_FieldValue);
			newXMLElement -> AddAttribute (XML_CITEMFIELDVALUESTRING_ATTR_EDITABLE, CString(m_Enabled ? "true" : "false"));
			ioXMLElementNode = newXMLElement -> GetXMLElementNode ();
		}
		break;
		case XML_READ :
		{
			CXMLElementNode *inXMLNode = ::xml_node_get_child (ioXMLElementNode, XML_CITEMFIELDVALUESTRING_ELEMENT);
                        if (inXMLNode == NULL)
                                throw new CException (CString("CItemFieldValueString::Serialize, specified xml node is not a \"") +
                                                              XML_CITEMFIELDVALUESTRING_ELEMENT + CString("\" element one."), 
						      	      __exception(XMLPARSE));
			m_Enabled    = ::xml_node_get_attribute (inXMLNode, XML_CITEMFIELDVALUESTRING_ATTR_EDITABLE).GetValue().ToBool();
			m_FieldValue = ::xml_node_get_value 	(inXMLNode);
			ioXMLElementNode = inXMLNode;
		}
		break;
	}
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// CItemFieldValueBoolean
//-----------------------------------------------------------------------------------------------------------------------------------------

RESOLVE_DYNAMIC_METACLASS (CItemFieldValueBoolean);

CItemFieldValueBoolean::CItemFieldValueBoolean (const bool inFieldValue, const bool inEnabled, const bool inVisible)
		       :CItemFieldValue	       (inVisible),
			m_Enabled	       (inEnabled),
			m_FieldValue	       (inFieldValue)
{ }

CItemFieldValueBoolean::~CItemFieldValueBoolean ()
{ }

void CItemFieldValueBoolean::SetEnabled (const bool inEnabled)
{
	m_Enabled = inEnabled;
	if (m_Listener != NULL) static_cast <CItemFieldValueAPIListener *> (m_Listener) -> OnStateChange (this);
}

bool CItemFieldValueBoolean::GetEnabled () const
{
	return m_Enabled;
}

void CItemFieldValueBoolean::SetFieldValue (const bool inFieldValue)
{
	m_FieldValue = inFieldValue;
	if (m_Listener != NULL) static_cast <CItemFieldValueAPIListener *> (m_Listener) -> OnStateChange (this);
}

bool CItemFieldValueBoolean::GetFieldValue () const
{
	return m_FieldValue;
}

CItemFieldValue & CItemFieldValueBoolean::operator = (const bool inFieldValue)
{
	SetFieldValue (inFieldValue);
	return *this;
}

CItemFieldValue & CItemFieldValueBoolean::operator = (const CItemFieldValueBoolean &inFieldValue)
{
	m_FieldValue = inFieldValue.m_FieldValue;
	m_Enabled    = inFieldValue.m_Enabled;
	if (m_Listener != NULL) static_cast <CItemFieldValueAPIListener *> (m_Listener) -> OnStateChange (this);
	return *this;
}

static CString XML_CITEMFIELDVALUEBOOLEAN_ELEMENT	("citemfieldvalueboolean");
static CString XML_CITEMFIELDVALUEBOOLEAN_ATTR_ENABLED	("enabled");
static CString XML_CITEMFIELDVALUEBOOLEAN_ATTR_VALUE	("value");

void CItemFieldValueBoolean::Serialize (CXMLElementNode *&ioXMLElementNode, const int inMode) THROWABLE
{
	CItemFieldValue::Serialize (ioXMLElementNode, inMode);
	switch (inMode)
	{
		case XML_WRITE :
		{
			CXMLElement *newXMLElement = new CXMLElement (ioXMLElementNode, XML_CITEMFIELDVALUEBOOLEAN_ELEMENT);
			newXMLElement -> AddAttribute (XML_CITEMFIELDVALUEBOOLEAN_ATTR_ENABLED, CString(m_Enabled    ? "true" : "false"));
			newXMLElement -> AddAttribute (XML_CITEMFIELDVALUEBOOLEAN_ATTR_VALUE,   CString(m_FieldValue ? "true" : "false"));
			ioXMLElementNode = newXMLElement -> GetXMLElementNode ();
		}
		break;
		case XML_READ :
		{
			CXMLElementNode *inXMLNode = ::xml_node_get_child (ioXMLElementNode, XML_CITEMFIELDVALUEBOOLEAN_ELEMENT);
                        if (inXMLNode == NULL)
                                throw new CException (CString("CItemFieldValueBoolean::Serialize, specified xml node is not a \"") +
                                                              XML_CITEMFIELDVALUEBOOLEAN_ELEMENT + CString("\" element one."), 
						      	      __exception(XMLPARSE));
			m_Enabled    = ::xml_node_get_attribute (inXMLNode, XML_CITEMFIELDVALUEBOOLEAN_ATTR_ENABLED).GetValue().ToBool();
			m_FieldValue = ::xml_node_get_attribute (inXMLNode, XML_CITEMFIELDVALUEBOOLEAN_ATTR_VALUE).  GetValue().ToBool();
			ioXMLElementNode = inXMLNode;
		}
		break;
	}
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// CItemFieldValuePixbuf
//-----------------------------------------------------------------------------------------------------------------------------------------

RESOLVE_DYNAMIC_METACLASS (CItemFieldValuePixbuf);

CItemFieldValuePixbuf::CItemFieldValuePixbuf (const CPixbuf *inFieldValue, const bool inVisible)
		      :CItemFieldValue	     (inVisible),
		       m_FieldValue	     (const_cast <CPixbuf *> (inFieldValue))
{ }

CItemFieldValuePixbuf::~CItemFieldValuePixbuf ()
{
	if (m_FieldValue != NULL) delete m_FieldValue;
}

void CItemFieldValuePixbuf::SetFieldValue (const CPixbuf *inFieldValue)
{
	m_FieldValue = const_cast <CPixbuf *> (inFieldValue);
	if (m_Listener != NULL) static_cast <CItemFieldValueAPIListener *> (m_Listener) -> OnStateChange (this);
}

CPixbuf * CItemFieldValuePixbuf::GetFieldValue () const
{
	return const_cast <CPixbuf *> (m_FieldValue);
}

CItemFieldValue & CItemFieldValuePixbuf::operator = (const CPixbuf *inFieldValue)
{
	SetFieldValue (inFieldValue);
	return *this;
}

static CString XML_CITEMFIELDVALUEPIXBUF_ELEMENT	("citemfieldvaluepixbuf");
static CString XML_CITEMFIELDVALUEPIXBUF_ATTR_VALUE	("value");

void CItemFieldValuePixbuf::Serialize (CXMLElementNode *&ioXMLElementNode, const int inMode) THROWABLE
{
	CItemFieldValue::Serialize (ioXMLElementNode, inMode);
	switch (inMode)
	{
		case XML_WRITE :
		{
			CXMLElement *newXMLElement = new CXMLElement (ioXMLElementNode, XML_CITEMFIELDVALUEPIXBUF_ELEMENT);
			newXMLElement -> AddAttribute (XML_CITEMFIELDVALUEPIXBUF_ATTR_VALUE, 
								CString(m_FieldValue!=NULL?m_FieldValue->GetName():""));
			ioXMLElementNode = newXMLElement -> GetXMLElementNode ();
		}
		break;
		case XML_READ :
		{
			CXMLElementNode *inXMLNode = ::xml_node_get_child (ioXMLElementNode, XML_CITEMFIELDVALUEPIXBUF_ELEMENT);
                        if (inXMLNode == NULL)
                                throw new CException (CString("CItemFieldValuePixbuf::Serialize, specified xml node is not a \"") +
                                                              XML_CITEMFIELDVALUEPIXBUF_ELEMENT + CString("\" element one."), 
						      	      __exception(XMLPARSE));
			CString inName = ::xml_node_get_attribute (inXMLNode, XML_CITEMFIELDVALUEPIXBUF_ATTR_VALUE).GetValue();
			if (inName.Find(CString("id:")))
				m_FieldValue = new CPixbuf (inName.Cut(CString("id:"))[1]->Get());
			else if (inName != CString())
				m_FieldValue = new CPixbuf (inName);
			else
				m_FieldValue = NULL;
			ioXMLElementNode = inXMLNode;
		}
		break;
	}
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// CItemFieldValueCombo
//-----------------------------------------------------------------------------------------------------------------------------------------

RESOLVE_DYNAMIC_METACLASS (CItemFieldValueCombo);

/*
CItemFieldValueCombo::CItemFieldValueCombo (const CItemFieldValues &inFieldValues, const bool inEntry, const bool inVisible) THROWABLE
		     :CItemFieldValue	   (inVisible),
		      m_Model		   (),
		      m_FieldValues	   (inFieldValues),
		      m_Entry		   (inEntry),
		      m_GtkListStore	   (NULL)
{
	NServices::TBuffer <GType> outGTypeBuffer;
	for (size_t i=m_FieldValues.GetLength(), j=0; i>0; i--, j++)
	{	
		m_Model += metaclass_cast ((*m_FieldValues[j]));
		if (CMetaClass::MetaClassIs (__metaclass(CItemFieldValueCombo), *m_Model[j]))
			throw new CException (CString("CItemFieldValueCombo cannot handle a sub combo field value item."), 
					      __exception(BADPARAMETER));
		if (CMetaClass::MetaClassIs (__metaclass(CItemFieldValueProgress), *m_Model[j]))
			throw new CException (CString("CItemFieldValueCombo cannot handle a sub progress field value item."), 
					      __exception(BADPARAMETER));
		if (CMetaClass::MetaClassIs (__metaclass(CItemFieldValueString), *m_Model[j]))
			outGTypeBuffer += G_TYPE_STRING;
		if (CMetaClass::MetaClassIs (__metaclass(CItemFieldValueBoolean), *m_Model[j]))
			outGTypeBuffer += G_TYPE_BOOLEAN;
		if (CMetaClass::MetaClassIs (__metaclass(CItemFieldValuePixbuf), *m_Model[j]))
			;
	}
	GtkTreeIter m_GtkTreeIter;
	m_GtkListStore = ::gtk_list_store_newv (outGTypeBuffer.GetLength(), outGTypeBuffer.Get());
	::gtk_list_store_append (m_GtkListStore, &m_GtkTreeIter);
	for (size_t i=0; i<m_FieldValues.GetLength(); i++)
	{
		if (CMetaClass::MetaClassIs (__metaclass(CItemFieldValueString), *m_Model[i]))
		{
			GValue outGValue; ::g_value_init (&outGValue, G_TYPE_STRING);
			::g_value_set_string (&outGValue, 
				static_cast <CItemFieldValueString *> (*m_FieldValues[i]) -> GetFieldValue().Get());
			::gtk_list_store_set_value (m_GtkListStore, &m_GtkTreeIter, i, &outGValue);
		}
		if (CMetaClass::MetaClassIs (__metaclass(CItemFieldValueBoolean), *m_Model[i]))
		{
			GValue outGValue; ::g_value_init (&outGValue, G_TYPE_BOOLEAN);
			::g_value_set_boolean (&outGValue, 
				static_cast <CItemFieldValueBoolean *> (*m_FieldValues[i]) -> GetFieldValue());
			::gtk_list_store_set_value (m_GtkListStore, &m_GtkTreeIter, i, &outGValue);
		}
		if (CMetaClass::MetaClassIs (__metaclass(CItemFieldValuePixbuf), *m_Model[i]))
			;
	}
}

CItemFieldValueCombo::~CItemFieldValueCombo ()
{
	for (size_t i=m_FieldValues.GetLength(); i>0; i--) delete *m_FieldValues[i-1];
}

void CItemFieldValueCombo::Serialize (CXMLElementNode *&ioXMLElementNode, const int inMode) THROWABLE
{
	CItemFieldValue::Serialize (ioXMLElementNode, inMode);
	switch (inMode)
	{
		case XML_WRITE :
		{
		}
		break;
		case XML_READ :
		{
		}
		break;
	}
}
*/

//-----------------------------------------------------------------------------------------------------------------------------------------
// CItemFieldValueProgress
//-----------------------------------------------------------------------------------------------------------------------------------------

RESOLVE_DYNAMIC_METACLASS (CItemFieldValueProgress);

CItemFieldValueProgress::CItemFieldValueProgress (const float inFieldValue, const CString &inCaption, const bool inVisible)
			:CItemFieldValue	 (inVisible),
			 m_FieldValue		 (inFieldValue),
			 m_Caption		 (inCaption)
{ }

CItemFieldValueProgress::~CItemFieldValueProgress ()
{ }

void CItemFieldValueProgress::SetFieldValue (const float inFieldValue)
{
	m_FieldValue = inFieldValue;
	if (m_Listener != NULL) static_cast <CItemFieldValueAPIListener *> (m_Listener) -> OnStateChange (this);
}

float CItemFieldValueProgress::GetFieldValue () const
{
	return m_FieldValue;
}

void CItemFieldValueProgress::SetCaption (const CString &inCaption)
{
	m_Caption = inCaption;
	if (m_Listener != NULL) static_cast <CItemFieldValueAPIListener *> (m_Listener) -> OnStateChange (this);
}

CString CItemFieldValueProgress::GetCaption () const
{
	return m_Caption;
}

CItemFieldValue & CItemFieldValueProgress::operator = (const float inFieldValue)
{
	SetFieldValue (inFieldValue);
	return *this;
}

CItemFieldValue & CItemFieldValueProgress::operator = (const CItemFieldValueProgress &inFieldValue)
{
	m_FieldValue = inFieldValue.m_FieldValue;
	m_Caption    = inFieldValue.m_Caption;
	if (m_Listener != NULL) static_cast <CItemFieldValueAPIListener *> (m_Listener) -> OnStateChange (this);
}

CItemFieldValue & CItemFieldValueProgress::operator = (const CItemFieldValueString &inCaption)
{
	SetCaption (inCaption.GetFieldValue());
	return *this;
}

CItemFieldValue & CItemFieldValueProgress::operator = (const CString &inCaption)
{
	SetCaption (inCaption);
	return *this;
}

static CString XML_CITEMFIELDVALUEPROGRESS_ELEMENT	("citemfieldvalueprogress");
static CString XML_CITEMFIELDVALUEPROGRESS_ATTR_CAPTION	("caption");
static CString XML_CITEMFIELDVALUEPROGRESS_ATTR_VALUE	("value");

void CItemFieldValueProgress::Serialize (CXMLElementNode *&ioXMLElementNode, const int inMode) THROWABLE
{
	CItemFieldValue::Serialize (ioXMLElementNode, inMode);
	switch (inMode)
	{
		case XML_WRITE :
		{
			CXMLElement *newXMLElement = new CXMLElement (ioXMLElementNode, XML_CITEMFIELDVALUEPROGRESS_ELEMENT);
			newXMLElement -> AddAttribute (XML_CITEMFIELDVALUEPROGRESS_ATTR_VALUE,   CString((double)m_FieldValue));
			newXMLElement -> AddAttribute (XML_CITEMFIELDVALUEPROGRESS_ATTR_CAPTION, m_Caption);
			ioXMLElementNode = newXMLElement -> GetXMLElementNode ();
		}
		break;
		case XML_READ :
		{
			CXMLElementNode *inXMLNode = ::xml_node_get_child (ioXMLElementNode, XML_CITEMFIELDVALUEPROGRESS_ELEMENT);
                        if (inXMLNode == NULL)
                                throw new CException (CString("CItemFieldValueProgress::Serialize, specified xml node is not a \"") +
                                                              XML_CITEMFIELDVALUEPROGRESS_ELEMENT + CString("\" element one."), 
						      	      __exception(XMLPARSE));
			m_FieldValue = ::xml_node_get_attribute (inXMLNode, XML_CITEMFIELDVALUEPROGRESS_ATTR_VALUE).  GetValue().ToDouble();
			m_Caption    = ::xml_node_get_attribute (inXMLNode, XML_CITEMFIELDVALUEPROGRESS_ATTR_CAPTION).GetValue();
			ioXMLElementNode = inXMLNode;
		}
		break;
	}
}


