------------------------------------------------------------------------------
--                             G N A T C O L L                              --
--                                                                          --
--                     Copyright (C) 2009-2014, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with GNAT.IO;
with GNATCOLL.GMP.Integers;

use GNAT.IO;
use GNATCOLL.GMP.Integers;
use GNATCOLL.GMP;  --  for numeric types

procedure Test_Rem is

   R, A, B : Big_Integer;

begin
   Set (B, "5", 10);

   Set (A, "10", 10);
   Get_Rem (R, A, B);
   if R /= 0 then
      Put_Line ("test_rem failed: Get_Rem 10 rem 5 should = 0");
      return;
   end if;

   Set (A, "11", 10);
   Get_Rem (R, A, B);
   if R /= 1 then
      Put_Line ("test_rem failed: Get_Rem 11 rem 5 should = 1");
      return;
   end if;

   Set (A, "12", 10);
   Get_Rem (R, A, B);
   if R /= 2 then
      Put_Line ("test_rem failed: Get_Rem 12 rem 5 should = 2");
      return;
   end if;

   Set (A, "13", 10);
   Get_Rem (R, A, B);
   if R /= 3 then
      Put_Line ("test_rem failed: Get_Rem 13 rem 5 should = 3");
      return;
   end if;

   Set (A, "14", 10);
   Get_Rem (R, A, B);
   if R /= 4 then
      Put_Line ("test_rem failed: Get_Rem 14 rem 5 should = 4");
      return;
   end if;

----

   Set (A, "10", 10);
   Set (R, A rem B);
   if R /= 0 then
      Put_Line ("test_rem failed: 10 rem 5 should = 0");
      return;
   end if;

   Set (A, "11", 10);
   Set (R, A rem B);
   if R /= 1 then
      Put_Line ("test_rem failed: 11 rem 5 should = 1");
      return;
   end if;

   Set (A, "12", 10);
   Set (R, A rem B);
   if R /= 2 then
      Put_Line ("test_rem failed: 12 rem 5 should = 2");
      return;
   end if;

   Set (A, "13", 10);
   Set (R, A rem B);
   if R /= 3 then
      Put_Line ("test_rem failed: 13 rem 5 should = 3");
      return;
   end if;

   Set (A, "14", 10);
   Set (R, A rem B);
   if R /= 4 then
      Put_Line ("test_rem failed: 14 rem 5 should = 4");
      return;
   end if;

----

   Set (A, "-10", 10);
   Set (R, A rem B);
   if R /= 0 then
      Put_Line ("test_rem failed: -10 rem 5 should = 0");
      return;
   end if;

   Set (A, "-11", 10);
   Set (R, A rem B);
   if R /= -1 then
      Put_Line ("test_rem failed: -11 rem 5 should = -1");
      return;
   end if;

   Set (A, "-12", 10);
   Set (R, A rem B);
   if R /= -2 then
      Put_Line ("test_rem failed: -12 rem 5 should = -2");
      return;
   end if;

   Set (A, "-13", 10);
   Set (R, A rem B);
   if R /= -3 then
      Put_Line ("test_rem failed: -13 rem 5 should = -3");
      return;
   end if;

   Set (A, "-14", 10);
   Set (R, A rem B);
   if R /= -4 then
      Put_Line ("test_rem failed: -14 rem 5 should = -4");
      return;
   end if;

----
   Set (B, "-5", 10);

   Set (A, "10", 10);
   Set (R, A rem B);
   if R /= 0 then
      Put_Line ("test_rem failed: 10 rem -5 should = 0");
      return;
   end if;

   Set (A, "11", 10);
   Set (R, A rem B);
   if R /= 1 then
      Put_Line ("test_rem failed: 11 rem -5 should = 1");
      return;
   end if;

   Set (A, "12", 10);
   Set (R, A rem B);
   if R /= 2 then
      Put_Line ("test_rem failed: 12 rem -5 should = 2");
      return;
   end if;

   Set (A, "13", 10);
   Set (R, A rem B);
   if R /= 3 then
      Put_Line ("test_rem failed: 13 rem -5 should = 3");
      return;
   end if;

   Set (A, "14", 10);
   Set (R, A rem B);
   if R /= 4 then
      Put_Line ("test_rem failed: 14 rem -5 should = 4");
      return;
   end if;

----

   Set (A, "-10", 10);
   Set (R, A rem B);
   if R /= 0 then
      Put_Line ("test_rem failed: -10 rem -5 should = 0");
      return;
   end if;

   Set (A, "-11", 10);
   Set (R, A rem B);
   if R /= -1 then
      Put_Line ("test_rem failed: -11 rem -5 should = -1");
      return;
   end if;

   Set (A, "-12", 10);
   Set (R, A rem B);
   if R /= -2 then
      Put_Line ("test_rem failed: -12 rem -5 should = -2");
      return;
   end if;

   Set (A, "-13", 10);
   Set (R, A rem B);
   if R /= -3 then
      Put_Line ("test_rem failed: -13 rem -5 should = -3");
      return;
   end if;

   Set (A, "-14", 10);
   Set (R, A rem B);
   if R /= -4 then
      Put_Line ("test_rem failed: -14 rem -5 should = -4");
      return;
   end if;
----

   Put_Line ("test_rem passed");
end Test_Rem;
