/* $Id: init.c,v 1.9 2005/07/30 16:31:58 cegger Exp $
   ******************************************************************************

   LIBGCP: default color

   Copyright (C) 2000-2001 Christoph Egger	[Christoph_Egger@t-online.de]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

   ******************************************************************************
 */


#include "config.h"
#include <ggi/internal/gcp.h>
#include "color.h"


static int GGIopen(ggi_visual *vis, struct ggi_dlhandle *dlh,
		   const char *args, void *argptr, uint32_t *dlret)
{
	gcppriv *priv = LIBGGI_GCPEXT(vis);

	DPRINT_CORE("GGIopen(%p, %p, %s, %p, %p) called for color sublib\n",
	       vis, dlh, args ? args : "(NULL)", argptr, dlret);

#if 0
	COLOR_PRIV(vis) = malloc(sizeof(struct colorgcp_priv));
	if (COLOR_PRIV(vis) == NULL) return GGI_ENOMEM;
#endif


	/* Color palette manipulation
	 */

	/* RGBA */
	priv->MapRGBAColor = GGI_color_MapRGBAColor;
	priv->UnmapRGBAPixel = GGI_color_UnmapRGBAPixel;

	priv->PackRGBAColors = GGI_color_PackRGBAColors;
	priv->UnpackRGBAPixels = GGI_color_UnpackRGBAPixels;
	priv->GetRGBAPalette = GGI_color_GetRGBAPalette;
	priv->SetRGBAPalette = GGI_color_SetRGBAPalette;


	/* YUV */
	priv->MapYUVColor = GGI_color_MapYUVColor;
	priv->UnmapYUVPixel = GGI_color_UnmapYUVPixel;

	priv->PackYUVColors = GGI_color_PackYUVColors;
	priv->UnpackYUVPixels = GGI_color_UnpackYUVPixels;

	priv->GetYUVPalette = GGI_color_GetYUVPalette;
	priv->SetYUVPalette = GGI_color_SetYUVPalette;



	/* CMYK */
	priv->MapCMYKColor = GGI_color_MapCMYKColor;
	priv->UnmapCMYKPixel = GGI_color_UnmapCMYKPixel;

	priv->PackCMYKColors = GGI_color_PackCMYKColors;
	priv->UnpackCMYKPixels = GGI_color_UnpackCMYKPixels;

	priv->GetCMYKPalette = GGI_color_GetCMYKPalette;
	priv->SetCMYKPalette = GGI_color_SetCMYKPalette;



	/* HSV */
	priv->MapHSVColor = GGI_color_MapHSVColor;
	priv->UnmapHSVPixel = GGI_color_UnmapHSVPixel;

	priv->PackHSVColors = GGI_color_PackHSVColors;
	priv->UnpackHSVPixels = GGI_color_UnpackHSVPixels;

	priv->GetHSVPalette = GGI_color_GetHSVPalette;
	priv->SetHSVPalette = GGI_color_SetHSVPalette;



	/* Kodak PhotoCD */
	priv->MapYCCColor = GGI_color_MapYCCColor;
	priv->UnmapYCCPixel = GGI_color_UnmapYCCPixel;

	priv->PackYCCColors = GGI_color_PackYCCColors;
	priv->UnpackYCCPixels = GGI_color_UnpackYCCPixels;

	priv->GetYCCPalette = GGI_color_GetYCCPalette;
	priv->SetYCCPalette = GGI_color_SetYCCPalette;




        /* Gamma map manipulation
         */

	/* RGBA */
	priv->GetRGBAGamma = GGI_color_GetRGBAGamma;
	priv->SetRGBAGamma = GGI_color_SetRGBAGamma;

	priv->GetRGBAGammaMap = GGI_color_GetRGBAGammaMap;
	priv->SetRGBAGammaMap = GGI_color_SetRGBAGammaMap;



	/* YUV */
	priv->GetYUVGamma = GGI_color_GetYUVGamma;
	priv->SetYUVGamma = GGI_color_SetYUVGamma;

	priv->GetYUVGammaMap = GGI_color_GetYUVGammaMap;
	priv->SetYUVGammaMap = GGI_color_SetYUVGammaMap;



	/* CMYK */
	priv->GetCMYKGamma = GGI_color_GetCMYKGamma;
	priv->SetCMYKGamma = GGI_color_SetCMYKGamma;

	priv->GetCMYKGammaMap = GGI_color_GetCMYKGammaMap;
	priv->SetCMYKGammaMap = GGI_color_SetCMYKGammaMap;



	/* HSV */
	priv->GetHSVGamma = GGI_color_GetHSVGamma;
	priv->SetHSVGamma = GGI_color_SetHSVGamma;

	priv->GetHSVGammaMap = GGI_color_GetHSVGammaMap;
	priv->SetHSVGammaMap = GGI_color_SetHSVGammaMap;



	/* Kodak PhotoCD */
	priv->GetYCCGamma = GGI_color_GetYCCGamma;
	priv->SetYCCGamma = GGI_color_SetYCCGamma;

	priv->GetYCCGammaMap = GGI_color_GetYCCGammaMap;
	priv->SetYCCGammaMap = GGI_color_SetYCCGammaMap;



	/* Blending manipulation
	 */

	/* Color blending */
	priv->BlendColor = GGI_color_BlendColor;


	/* Luminance manipulation
	 */
	priv->GetLuminance = GGI_color_GetLuminance;


	/* Lightness manipulation
	 */
	priv->SetIntensity = GGI_color_SetIntensity;
	priv->GetIntensity = GGI_color_GetIntensity;



	*dlret = ( GGI_DL_EXTENSION | GGI_DL_OPCOLOR );
	return 0;
}	/* GGIopen */


static int GGIclose(ggi_visual *vis, struct ggi_dlhandle *dlh)
{
	DPRINT_CORE("GGIclose(%p, %p) called for color sublib\n",
	       vis, dlh);

#if 0
	free(COLOR_PRIV(vis));

	COLOR_PRIV(vis) = NULL;
#endif

	return 0;
}	/* GGIclose */


EXPORTFUNC
int GCPdl_color_gcp(int func, void **funcptr);

int GCPdl_color_gcp(int func, void **funcptr)
{
	DPRINT_CORE("GGIdl_color called\n");

	switch (func) {
	case GGIFUNC_open:
		*funcptr = GGIopen;
		return 0;
	case GGIFUNC_exit:
		*funcptr = NULL;
		return 0;
	case GGIFUNC_close:
		*funcptr = GGIclose;
		return 0;
	default:
		*funcptr = NULL;
	}	/* switch */

	return GGI_ENOTFOUND;
}	/* GCPdl_color */

/* This should be included by exactly _one_ file in each sublib. */
#include <ggi/internal/ggidlinit.h>
