=begin
  iconv.rb - Pseudo Iconv module

  If you don't have iconv but glib2, this library behaves
  as Iconv.iconv.

  Copyright (C) 2004  Masao Mutoh <mutoh@highway.ne.jp>

  You may redistribute it and/or modify it under the same
  license terms as Ruby.

  $Id: iconv.rb,v 1.1 2004/10/21 16:19:30 mutoh Exp $
=end
begin
  require 'iconv.so'
rescue LoadError
  begin
    require 'glib2'
    module Iconv
      module Failure; end
      class InvalidEncoding < ArgumentError;  include Failure; end
      class IllegalSequence < ArgumentError;  include Failure; end
      class InvalidCharacter < ArgumentError; include Failure; end

      def check_glib_version?(major, minor, micro)
        (GLib::BINDING_VERSION[0] > major ||
         (GLib::BINDING_VERSION[0] == major && 
          GLib::BINDING_VERSION[1] > minor) ||
         (GLib::BINDING_VERSION[0] == major && 
          GLib::BINDING_VERSION[1] == minor &&
          GLib::BINDING_VERSION[2] >= micro))
      end
      module_function :check_glib_version?

      if check_glib_version?(0, 11, 0)
        def iconv(to, from, str)
          begin
            GLib.convert(str, to, from).split(//)
          rescue GLib::ConvertError => e
            case e.code
            when GLib::ConvertError::NO_CONVERSION
              raise InvalidEncoding.new(str)
            when GLib::ConvertError::ILLEGAL_SEQUENCE
              raise IllegalSequence.new(str)
            else
              raise InvalidCharacter.new(str)
            end
          end
        end
      else
       def iconv(to, from, str)
         begin
           GLib.convert(str, to, from).split(//)
         rescue
           raise IllegalSequence.new(str)
         end
       end
      end
      module_function :iconv
    end
  rescue LoadError
    module Iconv
      module_function
      def iconv(to, from, str)
        warn "Iconv was not found." if $DEBUG
        str.split(//)
      end
    end
  end
end

if __FILE__ == $0
  puts Iconv.iconv("EUC-JP", "UTF-8", "ほげ").join
  begin
    puts Iconv.iconv("EUC-JP", "EUC-JP", "ほげ").join
  rescue Iconv::Failure
    puts $!
    puts $!.class
  end
end
