#line 35 "../noweb/s_page.nw"
/* gEDA - GPL Electronic Design Automation
 * libgeda - gEDA's library
 * Copyright (C) 1998-2000 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */


#line 11 "../noweb/s_page.nw"
/* DO NOT read or edit this file ! Use ../noweb/s_page.nw instead */

#line 58 "../noweb/s_page.nw"
#include <config.h>

#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_ASSERT_H
#include <assert.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include <gtk/gtk.h>
#include <libguile.h>

#include "defines.h"
#include "struct.h"
#include "globals.h"
#include "o_types.h"

#include "../include/prototype.h"

#ifdef HAVE_LIBDMALLOC
#include <dmalloc.h>
#endif

#line 92 "../noweb/s_page.nw"
static gint global_pid = 0;


#line 106 "../noweb/s_page.nw"
PAGE *s_page_new(TOPLEVEL * toplevel, const gchar * filename)
{
  PAGE *page;

  /* Now create a blank page */
  page = (PAGE *) g_new(PAGE, 1);

  page->pid = global_pid++;

  page->CHANGED = 0;

  /* big assumption here that page_filename isn't null */
  if (g_path_is_absolute(filename)) {
    page->page_filename = g_strdup(filename);
  } else {
    gchar *pwd = g_get_current_dir();
    page->page_filename = g_strconcat(pwd,
				      G_DIR_SEPARATOR_S, filename, NULL);
    g_free(pwd);
  }

  g_assert(toplevel->init_bottom != 0);
  page->coord_aspectratio = (((float) toplevel->init_right) /
			     ((float) toplevel->init_bottom));

  page->up = -2;
  page->page_control = 0;

  /* Init tile array */
  s_tile_init(toplevel, page);

  /* First one to setup head */
  page->object_head = s_basic_init_object("object_head");
  page->object_head->type = OBJ_HEAD;

  /* new selection mechanism */
  page->selection2_head = page->selection2_tail = o_selection_new_head();

  /* net/pin/bus stretch when doing moves */
  page->stretch_head = page->stretch_tail = s_stretch_new_head();

  page->complex_place_tail = page->complex_place_head =
      s_basic_init_object("complex_place_head");
  page->complex_place_tail->type = OBJ_HEAD;

  /* add p_attrib and p_attached_to */
  page->attrib_place_tail = page->attrib_place_head =
      s_basic_init_object("attrib_place_head");
  page->attrib_place_tail->type = OBJ_HEAD;

  /* do this just to be sure that object tail is truely correct */
  page->object_tail = return_tail(page->object_head);

  /* setup parent to point to list */
  /* this is used for attributes so */
  /* that we know which list to search */
  page->object_parent = page->object_head;

  /* init undo struct pointers */
  s_undo_init(page);

  page->object_lastplace = NULL;
  page->object_selected = NULL;

  set_window(toplevel, page,
	     toplevel->init_left, toplevel->init_right,
	     toplevel->init_top, toplevel->init_bottom);

  /* now append page to page list of toplevel */
  toplevel->page_tail->next = page;
  page->prev = toplevel->page_tail;
  page->next = NULL;
  toplevel->page_tail = page;

  return page;
}


#line 202 "../noweb/s_page.nw"
void s_page_delete(TOPLEVEL * toplevel, PAGE * page)
{
  PAGE *tmp;

  g_assert(page->pid != -1);

  /* we need to play with page_current because s_delete_list_fromstart() */
  /* make use of it (see s_tile_remove_object_all) */

  /* save page_current and switch to page */
  if (page == toplevel->page_current) {
    tmp = NULL;
  } else {
    tmp = toplevel->page_current;
    s_page_goto(toplevel, page);
  }

  /* first delete objects of page */
  s_delete_list_fromstart(toplevel, page->object_head);

  toplevel->REMOVING_SEL = 1;
  s_delete_list_fromstart(toplevel, page->complex_place_head);
  s_delete_list_fromstart(toplevel, page->attrib_place_head);
  o_selection_destroy_all(page->selection2_head);
  toplevel->REMOVING_SEL = 0;

#if DEBUG
  printf("Freeing page: %s\n", page->page_filename);
  s_tile_print(toplevel);
#endif
  s_tile_free_all(page);

  s_stretch_destroy_all(page->stretch_head);

  /* free current page undo structs */
  s_undo_free_all(toplevel, page);

  /* ouch, deal with parents going away and the children still around */
  page->up = -2;
  /* p_current->down = NULL; not needed */

  g_free(page->page_filename);

  /* now unlink page from its list */
  if (page->next) {
    page->next->prev = page->prev;
  } else {
    /* page if the tail of page list: update toplevel */
    g_assert(toplevel->page_tail == page);
    toplevel->page_tail = page->prev;
  }
  if (page->prev) {
    page->prev->next = page->next;
  }
#if DEBUG
  s_tile_print(toplevel);
#endif

  g_free(page);

#if 0 /* don't do this for now hack */ /* this is a per window free */
  o_attrib_free_current(w_current);
  o_complex_free_filename(w_current);
#endif

  /* restore page_current */
  if (tmp != NULL) {
    s_page_goto(toplevel, tmp);
  } else {
    /* page was page_current */
    toplevel->page_current = NULL;
    /* page_current must be updated by calling function */
  }

}



#line 293 "../noweb/s_page.nw"
void s_page_init_list(TOPLEVEL * toplevel)
{
  PAGE *head;

  g_assert(toplevel->page_head == NULL);

  head = (PAGE *) g_new(PAGE, 1);

  head->pid = -1;
  head->CHANGED = 0;
  head->page_filename = g_strdup("page_head");
  head->prev = NULL;
  head->next = NULL;
  /* this is important so that page_next and page_prev ignore the 
   * page head node 
   */
  head->page_control = -1;

  /* add head as page head of toplevel */
  toplevel->page_head = toplevel->page_tail = head;

}


#line 330 "../noweb/s_page.nw"
void s_page_delete_list(TOPLEVEL * toplevel)
{
  PAGE *p_current, *p_prev;

  p_current = toplevel->page_tail;

  while (p_current != NULL && p_current->pid != -1) {
    p_prev = p_current->prev;
    s_page_delete(toplevel, p_current);
    p_current = p_prev;
  }

  g_assert(p_current->pid == -1 &&
	   p_current->prev == NULL && p_current->next == NULL);

  /* Now free the head */
  g_free(p_current->page_filename);
  g_free(p_current);

  /* reset toplevel fields */
  toplevel->page_head = NULL;
  toplevel->page_tail = NULL;
  toplevel->page_current = NULL;

}



#line 368 "../noweb/s_page.nw"
void s_page_goto(TOPLEVEL * toplevel, PAGE * p_new)
{
  gchar *dirname;

  toplevel->page_current = p_new;

  dirname = g_dirname(p_new->page_filename);
  chdir(dirname);
  g_free(dirname);

}


#line 394 "../noweb/s_page.nw"
PAGE *s_page_search(TOPLEVEL * toplevel, const gchar * filename)
{
  PAGE *p_current;

  for (p_current = toplevel->page_head;
       p_current != NULL; p_current = p_current->next) {
    if (g_strcasecmp(p_current->page_filename, filename) == 0) {
      return p_current;
    }
  }

  return NULL;
}


#line 420 "../noweb/s_page.nw"
gint s_page_search_row(TOPLEVEL * toplevel, PAGE * p_findme)
{
  PAGE *p_current;

  for (p_current = toplevel->page_head;
       p_current != NULL; p_current = p_current->next) {
    if (p_current->clist_row == p_findme->clist_row) {
      return p_current->clist_row;
    }
  }

  return 0;			/* can't find page... well just select row 0 */
}


#line 447 "../noweb/s_page.nw"
void s_page_print_all(TOPLEVEL * toplevel)
{
  PAGE *p_current;

  g_assert(toplevel->page_head != NULL && toplevel->page_head->pid == -1);

  for (p_current = toplevel->page_head->next;
       p_current != NULL; p_current = p_current->next) {
    printf("FILENAME: %s\n", p_current->page_filename);
    print_struct_forw(p_current->object_head);
  }

}


#line 477 "../noweb/s_page.nw"
gint s_page_save_all(TOPLEVEL * toplevel)
{
  PAGE *p_save, *p_current;
  gint status = 0;

  g_assert(toplevel->page_head != NULL && toplevel->page_head->pid == -1);

  /* save current page */
  p_save = toplevel->page_current;

  for (p_current = toplevel->page_head->next;
       p_current != NULL; p_current = p_current->next) {
    /* make p_current the current page of toplevel */
    s_page_goto(toplevel, p_current);

    if (f_save(toplevel, p_current->page_filename)) {
      s_log_message("Saved [%s]\n", toplevel->page_current->page_filename);
      /* reset the CHANGED flag of p_current */
      p_current->CHANGED = 0;

    } else {
      s_log_message("Could NOT save [%s]\n",
		    toplevel->page_current->page_filename);
      /* increase the error counter */
      status++;
    }

  }

  /* restore current page */
  s_page_goto(toplevel, p_save);

  return status;
}



#line 529 "../noweb/s_page.nw"
gboolean s_page_check_changed(PAGE * head)
{
  PAGE *p_current;

  for (p_current = head; p_current != NULL; p_current = p_current->next) {
    if (p_current->CHANGED) {
      return TRUE;
    }
  }

  return FALSE;
}


#line 556 "../noweb/s_page.nw"
void s_page_clear_changed(PAGE * head)
{
  PAGE *p_current;

  for (p_current = head; p_current != NULL; p_current = p_current->next) {
    p_current->CHANGED = 0;
  }

}
