// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_QUARKLIST_H
#define _LIBGDAMM_QUARKLIST_H


#include <glibmm.h>

// -*- C++ -*- //

/* quarklist.h
 *
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 

#include <libgda/gda-quark-list.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _GdaQuarkList GdaQuarkList; }
#endif

namespace Gnome
{

namespace Gda
{

//TODO: Documentation: See http://bugzilla.gnome.org/show_bug.cgi?id=561173
/** Quark lists (lists of KEY=VALUE's).
 *
 * Parameter lists are used primarily in the parsing and creation of connection strings.
 *
 * @ingroup DataHandlers
 */
class QuarkList
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef QuarkList CppObjectType;
  typedef GdaQuarkList BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  QuarkList();

  explicit QuarkList(GdaQuarkList* gobject, bool make_a_copy = true);

  QuarkList(const QuarkList& other);
  QuarkList& operator=(const QuarkList& other);

  ~QuarkList();

  void swap(QuarkList& other);

  ///Provides access to the underlying C instance.
  GdaQuarkList*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const GdaQuarkList* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  GdaQuarkList* gobj_copy() const;

protected:
  GdaQuarkList* gobject_;

private:

  
  public:
    
  
  /** Removes all strings in the given Gda::QuarkList.
   */
  void clear();
  
  void add_from_string(const Glib::ustring& name, bool cleanup);
  
  /** Searches for the value identified by @a name in the given Gda::QuarkList.
   * @param name The name of the value to search for.
   * @return The value associated with the given key if found, or <tt>0</tt>
   * if not found.
   */
  Glib::ustring find(const Glib::ustring& name) const;
  
  /** Removes an entry from the Gda::QuarkList, given its name.
   * @param name An entry name.
   */
  void remove(const Glib::ustring& name);
      
  typedef sigc::slot<void, Glib::ustring, Glib::ustring> ForeachSlot;
  
  /** Calls the given function for each of the key/value pairs in @a qlist. The function is passed the key and value 
   * of each pair, and the given user_data parameter. @a qlist may not be modified while iterating over it.
   * @param func The function to call for each key/value pair.
   * @param user_data User data to pass to the function.
   */

  void foreach(const ForeachSlot& func);
      

};

} // namespace Gda

} // namespace Gnome


namespace Gnome
{

namespace Gda
{

/** @relates Gnome::Gda::QuarkList
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(QuarkList& lhs, QuarkList& rhs)
  { lhs.swap(rhs); }

} // namespace Gda

} // namespace Gnome

namespace Glib
{

/** A Glib::wrap() method for this object.
 * 
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gnome::Gda::QuarkList
 */
Gnome::Gda::QuarkList wrap(GdaQuarkList* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gnome::Gda::QuarkList> : public Glib::Value_Boxed<Gnome::Gda::QuarkList>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _LIBGDAMM_QUARKLIST_H */

