/**
 * @file presence-feed.c Sample presence feed.
 *
 * @Copyright (C) 2004-2006 Christian Hammond
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#include <glib.h>
#include <libgalago/galago.h>
#include <stdio.h>
#include <string.h>

static void
setup_info(void)
{
	GalagoService *aim_service, *yahoo_service;
	GalagoAccount *account;
	GalagoAccount *contact;
	GalagoPerson *me, *person;
	GalagoPresence *presence;
	GalagoStatus *status;

	/* Setup our services */
	aim_service   = galago_create_service(GALAGO_SERVICE_ID_AIM, NULL, 0);
	yahoo_service = galago_create_service(GALAGO_SERVICE_ID_YAHOO, NULL, 0);

	/* Create our local person */
	me = galago_get_me(GALAGO_LOCAL, FALSE);

	/* Setup our person's AIM account */
	account  = galago_service_create_account(aim_service, me, "GalagoAIMUser2");
	presence = galago_account_create_presence(account);

	status = galago_status_new(GALAGO_STATUS_AWAY, "available", "Available",
							   TRUE);
	galago_object_set_attr_string(GALAGO_OBJECT(status), "message",
								  "Talk to me!");

	galago_presence_add_status(presence, status);

	/* Add contacts to our AIM account */
	person   = galago_create_person("gonkulator");
	contact  = galago_service_create_account(aim_service, person, "lottabs2");
	presence = galago_account_create_presence(contact);

	galago_presence_set_idle(presence, TRUE, time(NULL));

	galago_account_add_contact(account, contact);

	contact  = galago_service_create_account(aim_service, person,
											 "GonkulatorGalago");
	presence = galago_account_create_presence(contact);

	galago_account_add_contact(account, contact);

	/* Setup our person's Yahoo account */
	account  = galago_service_create_account(yahoo_service, me,
											 "GalagoYahooUser");
	presence = galago_account_create_presence(account);

	status = galago_status_new(GALAGO_STATUS_AVAILABLE, "available",
							   "Available", TRUE);

	galago_presence_add_status(presence, status);

	/* Add contacts to our Yahoo account */
	person   = galago_create_person("chipx86");
	contact  = galago_service_create_account(yahoo_service, person, "ChipX86");
	presence = galago_account_create_presence(contact);

	status = galago_status_new(GALAGO_STATUS_AVAILABLE, "available",
							   "Available", TRUE);
	galago_presence_add_status(presence, status);

	galago_account_add_contact(account, contact);
}

int
main(int argc, char **argv)
{
	GMainLoop *loop;

	loop = g_main_loop_new(NULL, FALSE);

	if (!galago_init("test-feed-2", GALAGO_INIT_FEED))
	{
		fprintf(stderr, "Unable to initialize Galago and connect "
				"to the server\n");
		exit(1);
	}

	setup_info();

	g_main_loop_run(loop);

	return 0;
}
