/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#ifndef STDIO16_H
#define STDIO16_H

#include <stdarg.h>
#include <stdio.h>
#ifdef HAVE_LIBZ
#include "zlib.h"
#endif
#include "charset.h"

typedef struct _FILE16 FILE16;

extern STD_API FILE16 *Stdin, *Stdout, *Stderr;

STD_API FILE16 *MakeFILE16FromFILE(FILE *f, const char *type);
STD_API FILE16 *MakeFILE16FromString(void *buf, long size, const char *type);
#ifdef WIN32
#ifdef SOCKETS_IMPLEMENTED
STD_API FILE16 *MakeFILE16FromWinsock(int sock, const char *type);
#endif
#endif
#ifdef HAVE_LIBZ
STD_API FILE16 *MakeFILE16FromGzip(gzFile file, const char *type);
#endif

STD_API int Readu(FILE16 *file, unsigned char *buf, int max_count);
STD_API int Writeu(FILE16 *file, unsigned char *buf, int count);
STD_API int Fclose(FILE16 *file);
STD_API int Fflush(FILE16 *file);
STD_API int Fseek(FILE16 *file, long offset, int ptrname);

STD_API FILE *GetFILE(FILE16 *file);
STD_API void SetCloseUnderlying(FILE16 *file, int cu);
STD_API void SetFileEncoding(FILE16 *file, CharacterEncoding encoding);
STD_API CharacterEncoding GetFileEncoding(FILE16 *file);

STD_API int Fprintf(FILE16 *file, const char *format, ...);
STD_API int Vfprintf(FILE16 *file, const char *format, va_list args);

STD_API int Printf(const char *format, ...);
STD_API int Vprintf(const char *format, va_list args);

STD_API int Sprintf(void *buf, CharacterEncoding enc, const char *format, ...);
STD_API int Vsprintf(void *buf, CharacterEncoding enc, const char *format, 
       va_list args);

STD_API void init_stdio16(void);

#endif /* STDIO16_H */
