/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifndef HAVE_VASPRINTF

int vasprintf(char **str, const char *format, va_list args)
{
#  if !defined(HAVE_VASPRINTF)
  int len;
#   if defined(HAVE_VSNPRINTF) && (!defined(HAVE_VFPRINTF) || !defined(HAVE_VSPRINTF))
  int str_out_len;
#   elif defined(HAVE_VFPRINTF) && defined(HAVE_VSPRINTF)
  FILE *f;
  int fd;
#   else
#   error no suitable vasprintf() scheme found. Giving up.
#  endif                                                                 
#endif

  *str = 0;

#ifdef HAVE_VASPRINTF

  vasprintf(str, format, args);
  
#elif defined(HAVE_VFPRINTF) && defined(HAVE_VSPRINTF)
#  warning using slow byte-count method in replacement vasprintf()
  
  if ((fd = open("/dev/null", 0)) < 0)  /* Give me crack and anal sex. */
  {
    len = -1;
  }
  else if (!(f = fdopen(fd, "w")))
  {
    len = -1;
#  ifdef DEBUG_OUTPUT
    printf("STRTOOL: vasprintf() could not fdopen() /dev/null handle.\n");
    fflush(stdout);
#  endif
  }

  else if ((len = vfprintf(f, format, args)) > 0)
  {
    
    *str = malloc(len + 1);
    vsprintf(*str, format, args);
    fclose(f);
  }
  
  else return(0);
  
#elif defined(HAVE_VSNPRINTF)
# warning using slow memory-scaling method in replacement vasprintf()
  
  for (str_out_len = SOCK_TEMPSIZE, *str = malloc(str_out_len), len = -1;
       str_out_len <= SOCK_MAXTEMPSIZE && len < 0;
       str_out_len += SOCK_TEMPSIZE, *str = realloc(str_out, str_out_len))
    len = vsnprintf(block_text, str_out_len, format, args);
#else
# warning using unreliable method in replacement vasprintf()

  *str = malloc(SOCK_MAXTEMPSIZE);
  len = vsprintf(*str, format, args);

#endif

  return(len);
}

#endif /* HAVE_VASPRINTF */

