#include <ept/tests/test-utils.h>
#include <ept/cache/apt/records.h>
#include <ept/cache/apt/packages.h>

namespace tut {

using namespace ept;
using namespace configuration::apt;
using namespace cache;

struct cache_apt_records_shar : common {};

TESTGRP(cache_apt_records);

using namespace cache;

template<> template<>
void to::test<1> ()
{
    Records *rc = &apt.records();
    Package p = apt.index().packageByName( "postfix" );
    Records::Record rec = rc->record( p.installedVersion() );
    ensure_equals( rec.shortDescription, "A high-performance mail transport agent" );
}

template<> template<>
void to::test<2> ()
{
    Records *rc = &apt.records();
    Package p = apt.index().packageByName("postfix");
    Records::Record rec = rc->record(p.installedVersion());
    ensure_equals( rec.shortDescription, "A high-performance mail transport agent" );
    rec = rc->record( p.installedVersion() );
    ensure_equals( rec.shortDescription, "A high-performance mail transport agent" );
}

template<> template<>
void to::test<3> ()
{
    Records *rc = &apt.records();
    Package p = apt.index().packageByName("postfix");
    Records::Record rec = rc->record( p.installedVersion() );
    ensure_equals( rec.longDescription,
" Postfix is Wietse Venema's mail transport agent that started life as an\n\
 alternative to the widely-used Sendmail program.  Postfix attempts to\n\
 be fast, easy to administer, and secure, while at the same time being\n\
 sendmail compatible enough to not upset existing users. Thus, the outside\n\
 has a sendmail-ish flavor, but the inside is completely different.\n\
 .\n\
 This package does not have SASL or TLS support.  For SASL and TLS support,\n\
 install postfix-tls." );
}

}

#include <ept/cache/apt/records.tcc>
#include <ept/cache/apt/index.tcc> // for now
#include <ept/cache/apt/packages.tcc>
