/***************************************************************************
                          cmessagehandler.h  -  description
                             -------------------
    begin                : Sun Sep 30 2001
    copyright            : (C) 2001-2003 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CMESSAGEHANDLER_H
#define CMESSAGEHANDLER_H

/**
  *@author Mathias Küster
  *
  * This parses protocol strings and returns dclib objects.
  *
  * This always handles all protocol commands, although
  * some commands may only make sense for peer or hub connections,
  * or when those connections are in certain states.
  *
  * Also there may be some coding by copy and paste, since
  * some commands have the same content e.g. $ADCGET / $ADCSND.
  *
  * There are various legacy commands parsed, plus the protocol is
  * somewhat undefined, mostly anything unknown from the hub must be
  * shown as chat, what strings hubs are supposed to return in their
  * Supports response was apparently left open to interpretation,
  * some of the parameters for UserCommand may be optional although
  * they shouldn't be e.g. spacers without names.
  *
  * DC++ does not use LogedIn, so it should not be used.
  */

#include <dclib/dcos.h>
#include <dclib/dcobject.h>
#include <dclib/core/cstring.h>

class CIconv;

class CMessageHandler {
public: 
	/** */
	CMessageHandler( CString remoteEncoding = CString() );
	/** */
	virtual ~CMessageHandler();

	/** */
	eDCMessage Parse( const CString * sMessage, int & pointer, CDCMessage ** DCMessage );

private:
	/** */
	bool GetContent( const CString sMessage, const CString * sData, CString & sContent );

	/** */
	CDCMessage * ParseLock( const CString & sContent );
	/** */
	CDCMessage * ParseHello( const CString & sContent );
	/** */
	CDCMessage * ParseMyNick( const CString & sContent );
	/** */
	CDCMessage * ParseChat( const CString & sContent );
	/** */
	CDCMessage * ParseMyInfo( const CString & sContent );
	/** */
	CDCMessage * ParseNickList( const CString & sContent );
	/** */
	CDCMessage * ParseOpList( const CString & sContent );
	/** */
	CDCMessage * ParseConnectToMe( const CString & sContent );
	/** */
	CDCMessage * ParseRevConnectToMe( const CString & sContent );
	/** */
	CDCMessage * ParseQuit( const CString & sContent );
	/** */
	CDCMessage * ParseSearch( const CString & sContent );
	/** */
	CDCMessage * ParseSearchResult( const CString & sContent );
	/** */
	CDCMessage * ParseSearchResultFile( const CString & sContent );
	/** */
	CDCMessage * ParseSearchResultFolder( const CString & sContent );
	/** */
	CDCMessage * ParsePrivateChat( const CString & sContent );
	/** */
	CDCMessage * ParseForceMove( const CString & sContent );
	/** */
	CDCMessage * ParseDirection( const CString & sContent );
	/** */
	CDCMessage * ParseFileLength( const CString & sContent );
	/** */
	CDCMessage * ParseGet( const CString & sContent );
	/** */
	CDCMessage * ParseUGetBlock( const CString & sContent );
	/** */
	CDCMessage * ParseUGetZBlock( const CString & sContent );
	/** */
	CDCMessage * ParseError( const CString & sContent );
	/** */
	CDCMessage * ParseGetInfo( const CString & sContent );
	/** */
	CDCMessage * ParseHubName( const CString & sContent );
	/** */
	CDCMessage * ParseLogedIn( CString sContent );
	/** */
	CDCMessage * ParseSupports( CString sContent );
	/** */
	CDCMessage * ParseHubTopic( const CString & sContent );
	/** */
	CDCMessage * ParseUserCommand( const CString & sContent );
	/** */
	CDCMessage * ParseGetZBlock( const CString & sContent );
	/** */
	CDCMessage * ParseSending( const CString & sContent );
	/** */
	CDCMessage * ParseADCGet( const CString & sContent );
	/** */
	CDCMessage * ParseADCSnd( const CString & sContent );
	/** Parse UserIP message */
	CDCMessage * ParseUserIP( CString sContent );

	/** CIconv object for doing text encoding remote to local */
	CIconv * m_pRemoteToLocal;
	/** CIconv object for doing UTF-8 to local for certain commands */
	CIconv * m_pUTF8ToLocal;
};

#endif
