/***************************************************************************
                          populate.cpp  -  description
                             -------------------
    begin                : Sun Dec 23 2001
    copyright            : (C) 2001 by root
    email                : root@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dbmusic.h"
/* Put here so it's not automatically included by dbinit.h */
#include "dbmusicvalidator.h"

/** Populates QStringList with artist names (for a combobox).
 *
 * Returns error code.
 *@param QStringList Pointer to the list
 */
void dbMusic::populateArtistQList(QStringList *const l) const
{
	if (!l)
		return;
	cerr << "Filling Artist StringList from cache." << endl;
	StringHashQMap::Iterator it;
	for (it=artist->begin();it!=artist->end();++it)
		l->append(it.key());
}
/** Fills the qmap with category information.
 *@param int Which value to populate (genre, label, etc.)
 *@param QStringList Pointer to the list to be filled.
 */
void dbMusic::populateCategoryQList(const int &t, QStringList *const list)
{
	cerr << "Populating CategoryQList" << endl;
	StringHashQMap::Iterator it;
	StringHashQMap *temp=0;

	switch (t)
	{
		case KBOXSET:
			temp=boxset;
			break;
		case KFORMAT:
			temp=formatmap;
			break;
		case KGENRE:
			temp=genremap;
			break;
		case KLABEL:
			temp=labelmap;
			break;
		case KMETHOD:
			temp=methodmap;
			break;
		case KTYPE:
			temp=typemap;
			break;
		default:
			return;
	};

	for (it=temp->begin();it!=temp->end();++it)
		list->append(it.key());
}
/** Populates the category QListView with the names of the chosen category.
 *
 *@param int Category type
 *@param QListView Pointer to QListView
 */
void dbMusic::populateCategoryQListView(const int &t, QListView *const list)
{
	cerr << "Populating CategoryQListView" << endl;
	StringHashQMap::Iterator it;
	StringHashQMap *temp=0;
	QListViewItem *item;

	switch (t)
	{
		case KBOXSET:
			temp=boxset;
			break;
		case KFORMAT:
			temp=formatmap;
			break;
		case KGENRE:
			temp=genremap;
			break;
		case KLABEL:
			temp=labelmap;
			break;
		case KMETHOD:
			temp=methodmap;
			break;
		case KTYPE:
			temp=typemap;
			break;
		case KBTE:
			sqlstring="SELECT name FROM explore";
			cerr << "getCategory: " << sqlstring << endl;
			stat=Exec(sqlstring.local8Bit().data());
			if (execCheck() < 0)
				return;

			break;
		default:
			return;
	};

	if (t==KBTE)
	{
		for (int i=0;i<Tuples();i++)
			item=new QListViewItem(list,GetValue(i,0));
	}
	else
	{
		for (it=temp->begin();it!=temp->end();++it)
			item=new QListViewItem(list,it.key());
	}

}
/** Fills up the information for the titleview.
 *
 * Returns error code
 *@param QString Artist name
 *@param QListView Pointer to QListView to be populated.
 */
int dbMusic::populateTitle(const QString &dex, QListView *const list, const enabledTitleColumns *const options)
{
	cerr << "Populating TitleListView" << endl;
	list->clear();
	if (dex.isEmpty())
		return TITLE_GET_FAIL;

	// define the boxset map to keep track of boxset pointers
	BoxSetMap *box=new BoxSetMap();
	if (!box)
		return NO_MEMORY;

	// assemble query from defaults, and send to server.
	sqlstring="SELECT cdid,grpid,name";
	if (options->fid)
		sqlstring.append(",fid");
	if (options->gid)
		sqlstring.append(",gid");
	if (options->lid)
		sqlstring.append(",lid");
	if (options->mid)
		sqlstring.append(",mid");
	if (options->tid)
		sqlstring.append(",tid");
	if (options->yearstart)
		sqlstring.append(",yearstart");
	if (options->yearend)
		sqlstring.append(",yearend");
	if (options->nod)
		sqlstring.append(",nod");
	if (options->notracks)
		sqlstring.append(",notracks");
	if (options->length)
		sqlstring.append(",cdlen");
	if (options->rating)
		sqlstring.append(",rating");
	if (options->quality)
		sqlstring.append(",quality");
	if (options->collected)
		sqlstring.append(",collected");
	sqlstring.append(" FROM title WHERE aid=");
	sqlstring.append(artist->find(dex).data());
	cerr << "getTitles: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if ((a=execCheck())<0)
		return a;
	int nt=Tuples();
	if (!nt)
		return EVERYTHING_OK;
	// our item bitch
	QListViewItem *item=0;
	int listnumber=1;
	QString grpid;

	// propagate the list
	for (int i=0;i<nt;i++) // iterate thru list and add titles
	{
		item=0;
		grpid=GetValue(i,1);
		if (strcmp(grpid,"1")==0) // if no box set
		{
			// just straight up add the add to the list view.
			item=new QListViewItem(list,GetValue(i,2));

			// set item values. we have to be careful because we DO NOT know what the query was
			// so we guess from the struct values and play tricks with the numbers.
			if (options->fid)
			{
				item->setText(listnumber,rformatmap->find(GetValue(i,listnumber+2)).data());
				listnumber++;
			}
			if (options->gid)
			{
				item->setText(listnumber,rgenremap->find(GetValue(i,listnumber+2)).data());
				listnumber++;
			}
			if (options->lid)
			{
				item->setText(listnumber,rlabelmap->find(GetValue(i,listnumber+2)).data());
				listnumber++;
			}
			if (options->mid)
			{
				item->setText(listnumber,rmethodmap->find(GetValue(i,listnumber+2)).data());
				listnumber++;
			}
			if (options->tid)
			{
				item->setText(listnumber,rtypemap->find(GetValue(i,listnumber+2)).data());
				listnumber++;
			}
			if (options->yearstart)
			{
				item->setText(listnumber,GetValue(i,listnumber+2));
				listnumber++;
			}
			if (options->yearend)
			{
				item->setText(listnumber,GetValue(i,listnumber+2));
				listnumber++;
			}
			if (options->nod)
			{
				item->setText(listnumber,GetValue(i,listnumber+2));
				listnumber++;
			}
			if (options->notracks)
			{
				item->setText(listnumber,GetValue(i,listnumber+2));
				listnumber++;
			}
			if (options->length)
			{
				item->setText(listnumber,GetValue(i,listnumber+2));
				listnumber++;
			}
			if (options->rating)
			{
				item->setText(listnumber,GetValue(i,listnumber+2));
				listnumber++;
			}
			if (options->quality)
			{
				item->setText(listnumber,GetValue(i,listnumber+2));
				listnumber++;
			}

			if (options->collected)
			{
				QString tf=GetValue(i,listnumber+2);
				if(tf=="t")
				{
					item->setPixmap(listnumber,SmallIcon("ok"));
					item->setText(listnumber+1,tf);
				}
				//set cdid
				item->setText(listnumber+2,GetValue(i,0));
			}
			else
			{
				item->setText(listnumber,GetValue(i,listnumber+2));
				//set cdid
				item->setText(listnumber+1,GetValue(i,0));
			}

		}
		else // if box set it checked
		{
			// look up boxset. If it isn't found, create a new item, then save the pointer.
			if (box->find(grpid)==box->end())
			{
				// create new boxset bitch item
				item=new QListViewItem(list, rboxset->find(grpid).data());
				// save pointer to box
				box->insert(grpid,item);
				item=0;
			}
			// lookup boxset name (qstring)
			item=new QListViewItem(box->find(grpid).data(),GetValue(i,2));
			// set item values. we have to be careful because we DO NOT know what the query was
			// so we guess from the struct values and play tricks with the numbers.
			if (options->fid)
			{
				item->setText(listnumber,rformatmap->find(GetValue(i,listnumber+2)).data());
				listnumber++;
			}
			if (options->gid)
			{
				item->setText(listnumber,rgenremap->find(GetValue(i,listnumber+2)).data());
				listnumber++;
			}
			if (options->lid)
			{
				item->setText(listnumber,rlabelmap->find(GetValue(i,listnumber+2)).data());
				listnumber++;
			}
			if (options->mid)
			{
				item->setText(listnumber,rmethodmap->find(GetValue(i,listnumber+2)).data());
				listnumber++;
			}
			if (options->tid)
			{
				item->setText(listnumber,rtypemap->find(GetValue(i,listnumber+2)).data());
				listnumber++;
			}
			if (options->yearstart)
			{
				item->setText(listnumber,GetValue(i,listnumber+2));
				listnumber++;
			}
			if (options->yearend)
			{
				item->setText(listnumber,GetValue(i,listnumber+2));
				listnumber++;
			}
			if (options->nod)
			{
				item->setText(listnumber,GetValue(i,listnumber+2));
				listnumber++;
			}
			if (options->notracks)
			{
				item->setText(listnumber,GetValue(i,listnumber+2));
				listnumber++;
			}
			if (options->length)
			{
				item->setText(listnumber,GetValue(i,listnumber+2));
				listnumber++;
			}
			if (options->rating)
			{
				item->setText(listnumber,GetValue(i,listnumber+2));
				listnumber++;
			}
			if (options->quality)
			{
				item->setText(listnumber,GetValue(i,listnumber+2));
				listnumber++;
			}

			if (options->collected)
			{
				QString tf=GetValue(i,listnumber+2);
				if(tf=="t")
				{
					item->setPixmap(listnumber,SmallIcon("ok"));
					item->setText(listnumber+1,tf);
				}
				//set cdid
				item->setText(listnumber+2,GetValue(i,0));
			}
			else
			{
				item->setText(listnumber,GetValue(i,listnumber+2));
				//set cdid
				item->setText(listnumber+1,GetValue(i,0));
			}
		}
		// reset list number to one for the next loop
		listnumber=1;
	}
	delete box;
	box=0;
	return EVERYTHING_OK;
}
/** Populates a QListView with the track information of a specified CD ID.
 *
 *@param QString CD ID
 *@param QListView Pointer to QListView
 */
int dbMusic::populateTrackListView(const QString &cdid, QListView *const list)
{
	cerr << "Populating TrackListView" << endl;
	list->clear();
	sqlstring="SELECT trackid,name,length from track WHERE cdid=";
	sqlstring.append(validateNumQString(cdid));
	sqlstring.append(" ORDER BY trackid");
	cerr << "getTracks: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if ((a=execCheck())<0)
		return a;
	int nt=Tuples();
	if (!nt)
		return EVERYTHING_OK;
	QListViewItem *item;
	QString trackno;
	for (int i=0;i<nt;i++)
	{
		trackno=trackno.setNum(i+1);
		if (i<9)
			trackno.insert(0,'0');
		item=new QListViewItem(list, trackno, GetValue(i,1), GetValue(i,2), GetValue(i,0));
	}

	return EVERYTHING_OK;

}
