/***************************************************************************
                          dbmusicvalidator.cpp  -  description
                             -------------------
    begin                : Wed Dec 19 2001
    copyright            : (C) 2001 by Will DeRousse
    email                : badhack@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dbmusicvalidator.h"

/**
 * Parses a QString for characters that a bash interface does not like (or could post a security
 * problem) and replaces them with '_'.
 * @param filename Name of file.
 */
QString validateFilename(const QString &string)
{
	cerr << "validateFilename: " << string;
	if (string.isEmpty())
		return string;
	QString t=string;
	QString badchars="&`';\\\"|*?<>(){}[]$\n\r";
	int z=t.length();
	int y=badchars.length();
	for (int i=0;i<z;i++)
	{
		for (int j=0;j<y;j++)
		{
			if (t[i]==badchars[j])
				t[i]='_';
		}
	}
	cerr << "\t" << t << endl;
	return t;

}

/**
 * Parses a QString for non-digit characters and converts them to a 1.
 *
 * Good for int submissions to a postgreSQL server
 * @param QString QString containing int value.
 */
QString validateNumQString(QString &string)
{
	cerr << "validateNumQString: " << string;
	if (string.isEmpty())
		return string;
	QString t=string;
	for (unsigned int i=0;i<t.length();i++)
	{
		if (t[i].isDigit() == 0)
			t[i]='1';
	}
	// if the number is not within postgreSQL limits, force it to the highest or lowest closest number.
	if(t.toFloat() < 0)
		t="0";
	if (t.toFloat() > 2147483647)
		t="2147483647";

	cerr << " to " << t << endl;
	return t;

}

/**
 * Parses a QString for non-digit characters and converts them to a 1.
 *
 * Good for int submissions to a postgreSQL server
 * @param QString QString containing int value.
 */
QString validateNumQString(const QString &string)
{
	cerr << "validateNumQString: " << string;
	if (string.isEmpty())
		return string;
	QString t=string;
	for (unsigned int i=0;i<t.length();i++)
	{
		if (t[i].isDigit() == 0)
			t[i]='1';
	}
	// if the number is not within postgreSQL limits, force it to the highest or lowest closest number.
	if(t.toFloat() < 0)
		t="0";
	if (t.toFloat() > 2147483647)
		t="2147483647";

	cerr << " to " << t << endl;
	return t;

}

/**
 * Parses a QString for non-digit characters and converts them to a one (const version).
 *
 * Good for int submissions to a postgreSQL server
 * @param QString QString containing value.
 */
QString validateQString(const QString &string)
{
	//	cerr << "validateQString: " << string;
	if (string.isEmpty())
		return string;
	QString t=string;
	int z=0;
	unsigned int y=0;
	do
	{
		z=t.find("'",z);
		if (z>-1)
		{
			y=z;
			t.insert(y,'\'');
			// skip this char and the '\'
			z+=2;
		}
	} while (z!=-1);

	//	cerr << "\t" << t << endl;
	return t;

}

/**
 * Parses a QString for ' characters and escapes (\') them.
 *
 * This will prevent postgreSQL from generating errors with ' in the name.
 * For example "INSERT INTO table (name) VALUES ('Apostrophe's')" would generate an error while
 * "INSERT INTO table (name) VALUES ('Apostrohpe''s')" would not.
 * @param QString QString containing value.
 */
QString validateQString(QString &string)
{
	//	cerr << "validateQString: " << string;
	if (string.isEmpty())
		return string;
	QString t=string;
	int z=0;
	unsigned int y=0;
	do
	{
		z=t.find("'",z);
		if (z>-1)
		{
			y=z;
			t.insert(y,'\'');
			// skip this char and the '\'
			z+=2;
		}
	} while (z!=-1);

	//	cerr << "\t" << t << endl;
	return t;

}

/**
 * Makes sure the QString is in an acceptable interval type format.
 *@param QString string to verify
 */
QString validateInterval(QString &s)
{
	QString z=s;
	uint length=0;
	// test to see if string is larger than 24 hours (2nd/3rd character will be blank as in 2 12:38:23).
	// if not, then we assume it is standard xx:xx:xx.
	if (z.length()<8)
		z="00:00:00";
	if (z[1].isSpace())
		length=10;
	else if (z[2].isSpace())
		length=11;
	else
		length=8;
	z.truncate(length);

	for (int i=0;i<2;i++)
	{
		if (!z[--length].isDigit())
			z[length]='0';
		if (!z[--length].isDigit())
			z[length]='0';
		if (z[--length] != ':')
			z[length]=':';
	}
		if (!z[--length].isDigit())
			z[length]='0';
		if (!z[--length].isDigit())
			z[length]='0';
	if (length > 0)
	{
		if (!z[--length].isSpace())
			z[length]=' ';
		if (!z[--length].isDigit())
			z[length]='0';
	}
	if (length > 0)
	{
		if (!z[--length].isDigit())
			z[length]='0';
	}
	return z;
}

/**
 * Makes sure the QString is in an acceptable interval type format. Const version.
 *@param QString string to verify
 */
QString validateInterval(const QString &s)
{
	QString z=s;
	uint length=0;
	// test to see if string is larger than 24 hours (2nd/3rd character will be blank as in 2 12:38:23).
	// if not, then we assume it is standard xx:xx:xx.
	if (z.length()<8)
		z="00:00:00";
	if (z[1].isSpace())
		length=10;
	else if (z[2].isSpace())
		length=11;
	else
		length=8;
	z.truncate(length);

	for (int i=0;i<2;i++)
	{
		if (!z[--length].isDigit())
			z[length]='0';
		if (!z[--length].isDigit())
			z[length]='0';
		if (z[--length] != ':')
			z[length]=':';
	}
		if (!z[--length].isDigit())
			z[length]='0';
		if (!z[--length].isDigit())
			z[length]='0';
	if (length > 0)
	{
		if (!z[--length].isSpace())
			z[length]=' ';
		if (!z[--length].isDigit())
			z[length]='0';
	}
	if (length > 0)
	{
		if (!z[--length].isDigit())
			z[length]='0';
	}
	return z;
}

/**
 * Returns the connect information string used by PostgreSQL.
 *
 *@param QString host
 *@param QString port
 *@param QString dbname
 *@param QString user
 *@param QString password
 */
QString returnConnectInfo(const QString &h, const QString &p, const QString &d, const QString &u, const QString &ps)
{
	return "host="+h+" port="+p+" dbname="+d+" user="+u+" password="+ps;
}
