# How to contribute #

## Ask questions ##

Yes, asking questions is a form of contribution that helps the author
improve documentation.

Feel free to ask questions by sending a mail to
[config-model-user mailing list](mailto:config-model-users@lists.sourceforge.net)

## Log a bug ##

Please report issue on  https://github.com/dod38fr/config-model-lcdproc/issues

## Source code structure ##

The main parts of this modules are:

* `lcdproc/LCDd.conf`: LcdProc config file copied from LcdProc source
* `script/lcdconf2model.pl`: analyses the above LCDd.conf and generates LcdProc model. See also this [blog](https://ddumont.wordpress.com/2011/07/03/generate-a-configuration-editor-from-a-config-template-file-with-perl-lcdproc-example/)
* `script/gen_LCDd_model.pl`: used during build to check whether LcdProc model need to be (re)generated
* `lib/Config/Model/system.d/`: declares the applications that `cme` can configure with this package
* `lib/Config/Model/LcdProc.pm`: the "main" file of the Perl package. Mostly contains docuementation.
* `lib/Config/Model/models/**.pl`: LcdProc model generated by `script/lcdconf2model.pl`. These files can be viewed with `cme meta edit` command. To change this model, either edit `LCDd.conf` comments or `lcdconf2model.pl`. The model structure can be viewed with `cme meta gen-dot` and `dot -Tps model.dot > model.ps`
* `lib/Config/Model/models/**.pod`: the doc of the above models. Can be re-generated with `cme gen_class_pod`
* `t`: test files. Run the tests with `prove -l t`
* `t/model_tests.d` test the application delivered with this module using [Config::Model::Tester](http://search.cpan.org/dist/Config-Model-Tester/lib/Config/Model/Tester.pm). Use `prove -l t/model_test.t` command to run only model tests.

## Edit source code from github ##

If you have a github account, you can clone a repo and prepare a pull-request.

You can:

* run `git clone https://github.com/dod38fr/config-model-lcdproc/`
* edit files
* run `prove -l t` to run non-regression tests

There's no need to worry about `dzil`, `Dist::Zilla` or `dist.ini`
files. These are useful to prepare a new release, but not to fix bugs.

## Edit source code from Debian source package  ##

You can also prepare a patch using Debian source package:

For instance:

* download and unpack `apt-get source libconfig-model-lcdproc-perl`
* jump in `cd libconfig-model-lcdproc-perl-2.xxx`
* useful to create a patch later: `git init`
* commit all files: `git add -A ; git commit -m"committed all"`
* edit files
* run `prove -l t` to run non-regression tests
* run `git diff` and send the output on [config-model-user mailing list](mailto:config-model-users@lists.sourceforge.net)


## Edit source code from Debian source package or CPAN tarball ##

Non Debian users can also prepare a patch using CPAN tarball:

* Download tar file from http://search.cpan.org
* unpack tar file with something like `tar axvf Config-Model-LcdProc-2.xxx.tar.gz`
* jump in `cd Config-Model-LcdProc-2.xxx`
* useful to create a patch later: `git init`
* commit all files: `git add -A ; git commit -m"committed all"`
* edit files
* run `prove -l t` to run non-regression tests
* run `git diff` and send the output on [config-model-user mailing list](mailto:config-model-users@lists.sourceforge.net)

## Provide feedback ##

Feedback is important. Please take a moment to rate, comment or add
stars to this project:

* [config-model github](https://github.com/dod38fr/config-model-lcdproc) or [config-model cpan ratings](http://cpanratings.perl.org/rate/?distribution=Config::Model::LcdProc)
