/*
  CLAW - a C++ Library Absolutely Wonderful

  CLAW is a free library without any particular aim but being useful to 
  anyone.

  Copyright (C) 2005-2008 Julien Jorge

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: julien_jorge@yahoo.fr
*/
/**
 * \file application.cpp
 * \brief Implementation of the claw::application class.
 * \author Julien Jorge
 */
#include "claw/application.hpp"
#include <claw/logger.hpp>

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param argc Number of arguments to the program.
 * \param argv The arguments of the program.
 * 
 * The constructor removes from argv all supported arguments, and updates the
 * value of argc.
 */
claw::application::application( int& argc, char** &argv )
  : m_arguments( argc, argv )
{
  m_arguments.add_long("--log-file",
                       "The file to use to store log informations.", true,
                       "file" );
  m_arguments.add_long("--log-level",
                       "Level of log informations:\n"
		       "\t\terror: error messages,\n"
                       "\t\twarning: warning and error messages,\n"
                       "\t\tverbose: all messages.", true, "string" );
  m_arguments.parse( argc, argv );

  if ( m_arguments.has_value("--log-file") )
    {
      std::string log_file = m_arguments.get_string("--log-file");
      logger.set( new file_logger(log_file) );
    }
  else
    logger.set( new console_logger() );

  if ( m_arguments.has_value( "--log-level" ) )
    {
      std::string level = m_arguments.get_string("--log-level");

      if (level == "error")
	logger.set_level( log_error );
      else if (level == "warning")
	logger.set_level( log_warning );
      else if (level == "verbose")
	logger.set_level( log_verbose );
      else
	logger.set_level( m_arguments.get_integer("--log-level") );
    }

} // application::application()

/*----------------------------------------------------------------------------*/
/**
 * \brief Destructor.
 */
claw::application::~application()
{
  logger.clear();
} // application::~application()
