------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                       Copyright (C) 2011, AdaCore                        --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Strings.Unbounded;

package body API is

   use Ada.Strings.Unbounded;

   K : Unbounded_String;
   V : Integer;

   ---------
   -- Set --
   ---------

   procedure Set (Key : String; Value : Integer) is
   begin
      K := To_Unbounded_String (Key);
      V := Value;
   end Set;

   ---------
   -- Get --
   ---------

   function Get (Key : String) return Integer is
   begin
      return V;
   end Get;

   ------------------
   -- Get_Last_Key --
   ------------------

   function Get_Last_Key return String is
   begin
      return To_String (K);
   end Get_Last_Key;

end API;
