//
//  libavg - Media Playback Engine. 
//  Copyright (C) 2003-2006 Ulrich von Zadow
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//  Current versions can be found at www.libavg.de
//
//  Original author of this file is igor@c-base.org 
//

#ifndef _Run_H_
#define _Run_H_

#include "../base/Point.h"

#include <boost/weak_ptr.hpp>

#include <vector>

namespace avg {

class Blob;
typedef boost::weak_ptr<class Blob> BlobWeakPtr;

struct Run
{
        Run(int row, int start_col, int end_col);
        int m_Row;
        int m_StartCol;
        int m_EndCol;
        int length();
        DPoint center();
        BlobWeakPtr m_pBlob;
};

typedef boost::shared_ptr<Run> RunPtr;
typedef std::vector<RunPtr> RunArray;

}

#endif
