# Copyright (c) 2001 Simon Wilkinson (sxw@sxw.org.uk). All rights reserved.
# This module is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

package Authen::SASL::Cyrus;

use strict;
use Carp;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK $AUTOLOAD);

require Exporter;
require DynaLoader;
require AutoLoader;

@ISA = qw(Exporter DynaLoader);

@EXPORT = qw(
	SASL_BADAUTH
	SASL_BADMAC
	SASL_BADPARAM
	SASL_BADPROT
	SASL_BADSERV
	SASL_BADVERS
	SASL_BUFOVER
	SASL_CB_AUTHNAME
	SASL_CB_ECHOPROMPT
	SASL_CB_GETOPT
	SASL_CB_GETPATH
	SASL_CB_GETREALM
	SASL_CB_LANGUAGE
	SASL_CB_LIST_END
	SASL_CB_LOG
	SASL_CB_NOECHOPROMPT
	SASL_CB_PASS
	SASL_CB_PROXY_POLICY
	SASL_CB_SERVER_GETSECRET
	SASL_CB_SERVER_PUTSECRET
	SASL_CB_USER
	SASL_CB_VERIFYFILE
	SASL_CONTINUE
	SASL_DISABLED
	SASL_ENCRYPT
	SASL_EXPIRED
	SASL_FAIL
	SASL_GETOPTCTX
	SASL_H
	SASL_INTERACT
	SASL_IP_LOCAL
	SASL_IP_REMOTE
	SASL_LOG_ERR
	SASL_LOG_INFO
	SASL_LOG_WARNING
	SASL_MAXOUTBUF
	SASL_MECHNAMEMAX
	SASL_NEWSECRET
	SASL_NOAUTHZ
	SASL_NOCHANGE
	SASL_NOMECH
	SASL_NOMEM
	SASL_NOPATH
	SASL_NOTDONE
	SASL_NOUSER
	SASL_OK
	SASL_PWLOCK
	SASL_REALM
	SASL_SECURITY_LAYER
	SASL_SEC_FORWARD_SECRECY
	SASL_SEC_NOACTIVE
	SASL_SEC_NOANONYMOUS
	SASL_SEC_NODICTIONARY
	SASL_SEC_NOPLAINTEXT
	SASL_SEC_PASS_CREDENTIALS
	SASL_SEC_PROPS
	SASL_SET_CREATE
	SASL_SET_DISABLE
	SASL_SSF
	SASL_SSF_EXTERNAL
	SASL_TOOWEAK
	SASL_TRANS
	SASL_TRYAGAIN
	SASL_USERNAME
	SASL_VERSION_MAJOR
	SASL_VERSION_MINOR
	SASL_VERSION_STEP
	SASL_VRFY_CONF
	SASL_VRFY_OTHER
	SASL_VRFY_PASSWD
	SASL_VRFY_PLUGIN
	SASL_WRONGMECH
);
$VERSION = '0.02';

bootstrap Authen::SASL::Cyrus $VERSION;

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.  If a constant is not found then control is passed
    # to the AUTOLOAD in AutoLoader.

    my $constname;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    croak "& not defined" if $constname eq 'constant';
    my $val = constant($constname, @_ ? $_[0] : 0);
    if ($! != 0) {
	if ($! =~ /Invalid/) {
	    $AutoLoader::AUTOLOAD = $AUTOLOAD;
	    goto &AutoLoader::AUTOLOAD;
	}
	else {
		croak "Your vendor has not defined Authen::SASL::Generic macro $constname";
	}
    }
    eval "sub $AUTOLOAD { $val }";
    goto &$AUTOLOAD;
}

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

Authen::SASL::Cyrus - Perl extension for Cyrus SASL library

=head1 SYNOPSIS

  use Authen::SASL::Cyrus;

  ...

=head1 DESCRIPTION

This is a very primitive interface to the Cyrus SASL library. The
implementation is far from complete - only the minimum necessary to get
GSSAPI authentication working is there.

=head1 FUNCTIONS

=over 4

=item error()

Returns the last error code from the most recent Authen::SASL::Cyrus call.
If evaluated in a string context, will return the textual description of 
the error.

=item $conn=init_connection($service, $server, $user)

Start a connection. $service is the service name (such as 'rcmd' or 'ldap'),
$server the FQDN of the server that is being connected to, and $user is the
username to connect as.

Returns the connection ID.

=item $mesg=start($conn, $mechanism)

$conn is the connection ID, $mechanism is a list of the mechanisms which are
available. $mesg is the message that should be sent to the server.

=item $mesg=respond($conn,$server_mesg)

$conn is the connection ID, $server_mesg is the message that was sent by the
server, $mesg is the data that should be sent back to the server to continue
the authentication process.

=head1 Exported constants

  SASL_BADAUTH
  SASL_BADMAC
  SASL_BADPARAM
  SASL_BADPROT
  SASL_BADSERV
  SASL_BADVERS
  SASL_BUFOVER
  SASL_CB_AUTHNAME
  SASL_CB_ECHOPROMPT
  SASL_CB_GETOPT
  SASL_CB_GETPATH
  SASL_CB_GETREALM
  SASL_CB_LANGUAGE
  SASL_CB_LIST_END
  SASL_CB_LOG
  SASL_CB_NOECHOPROMPT
  SASL_CB_PASS
  SASL_CB_PROXY_POLICY
  SASL_CB_SERVER_GETSECRET
  SASL_CB_SERVER_PUTSECRET
  SASL_CB_USER
  SASL_CB_VERIFYFILE
  SASL_CONTINUE
  SASL_DISABLED
  SASL_ENCRYPT
  SASL_EXPIRED
  SASL_FAIL
  SASL_GETOPTCTX
  SASL_H
  SASL_INTERACT
  SASL_IP_LOCAL
  SASL_IP_REMOTE
  SASL_LOG_ERR
  SASL_LOG_INFO
  SASL_LOG_WARNING
  SASL_MAXOUTBUF
  SASL_MECHNAMEMAX
  SASL_NEWSECRET
  SASL_NOAUTHZ
  SASL_NOCHANGE
  SASL_NOMECH
  SASL_NOMEM
  SASL_NOPATH
  SASL_NOTDONE
  SASL_NOUSER
  SASL_OK
  SASL_PWLOCK
  SASL_REALM
  SASL_SECURITY_LAYER
  SASL_SEC_FORWARD_SECRECY
  SASL_SEC_NOACTIVE
  SASL_SEC_NOANONYMOUS
  SASL_SEC_NODICTIONARY
  SASL_SEC_NOPLAINTEXT
  SASL_SEC_PASS_CREDENTIALS
  SASL_SEC_PROPS
  SASL_SET_CREATE
  SASL_SET_DISABLE
  SASL_SSF
  SASL_SSF_EXTERNAL
  SASL_TOOWEAK
  SASL_TRANS
  SASL_TRYAGAIN
  SASL_USERNAME
  SASL_VERSION_MAJOR
  SASL_VERSION_MINOR
  SASL_VERSION_STEP
  SASL_VRFY_CONF
  SASL_VRFY_OTHER
  SASL_VRFY_PASSWD
  SASL_VRFY_PLUGIN
  SASL_WRONGMECH

=head1 AUTHOR

Simon Wilkinson <sxw@sxw.org.uk>

=head1 BUGS

Its so primitive its untrue.

=head1 SEE ALSO

perl(1), sasl(1).

=cut
