/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.core;

import com.sun.tdk.signaturetest.SigTest;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.ConstructorDescr;
import com.sun.tdk.signaturetest.model.FieldDescr;
import com.sun.tdk.signaturetest.model.InnerDescr;
import com.sun.tdk.signaturetest.model.MemberCollection;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Erasurator {
    private Map globalParameters = new HashMap();
    private Map localParameters = new HashMap();
    private HashSet unresolvedWarnings = new HashSet();
    private static I18NResourceBundle i18n;
    private static Pattern simpleParamName;
    private static Pattern simpleParamUsage;
    private static Pattern replaceParamUsage;
    static /* synthetic */ Class class$com$sun$tdk$signaturetest$core$Erasurator;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ClassDescription erasure(ClassDescription clz) {
        ClassDescription result = (ClassDescription)clz.clone();
        this.globalParameters.clear();
        if (result.getTypeParameters() != null) {
            this.parseTypeParameters(result);
            result.setTypeParameters(null);
        }
        this.processMembers(result);
        return result;
    }

    public ClassDescription fullErasure(ClassDescription clz) {
        ClassDescription result = (ClassDescription)clz.clone();
        this.globalParameters.clear();
        if (result.getTypeParameters() != null) {
            this.parseTypeParameters(result);
            result.setTypeParameters(null);
        }
        this.processDeclaredMembers(result);
        return result;
    }

    private String convert(String s, Map globalParameters, Map localParameters) {
        Matcher m;
        String newS = s;
        while (newS.indexOf(60) != -1) {
            if (!$assertionsDisabled && newS.indexOf(62) == -1) {
                throw new AssertionError();
            }
            m = simpleParamUsage.matcher(newS);
            newS = m.replaceAll("");
        }
        if (globalParameters.size() == 0 && localParameters.size() == 0) {
            return newS;
        }
        m = replaceParamUsage.matcher(newS);
        while (m.find()) {
            String param = m.group();
            if (globalParameters.containsKey(param)) {
                newS = m.replaceFirst((String)globalParameters.get(param));
                m = replaceParamUsage.matcher(newS);
                continue;
            }
            if (localParameters.containsKey(param)) {
                newS = m.replaceFirst((String)localParameters.get(param));
                m = replaceParamUsage.matcher(newS);
                continue;
            }
            if (this.unresolvedWarnings.contains(param)) continue;
            System.out.println(i18n.getString("Erasurator.error.unresolved", param));
            this.unresolvedWarnings.add(param);
        }
        return newS;
    }

    public void parseTypeParameters(ClassDescription classDescr) {
        if (classDescr.getTypeParameters() != null) {
            Erasurator.parseTypeParameters(classDescr, this.globalParameters);
        }
    }

    private static void parseTypeParameters(MemberDescription member, Map parameters) {
        StringTokenizer st = new StringTokenizer(member.getTypeParameters(), "<>,");
        String ext = " extends ";
        boolean isClass = member.isClass();
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            Matcher m = simpleParamName.matcher(token);
            if (!m.lookingAt()) continue;
            String name = token.substring(m.start(), m.end());
            String key = isClass ? "{" + member.getQualifiedName() + name + "}" : "{%" + name + "}";
            if (token.length() <= m.end() || !token.substring(m.end()).startsWith(" extends ")) continue;
            String val = token.substring(m.end() + " extends ".length()).trim();
            if (val.indexOf(32) >= 0) {
                val = val.substring(0, val.indexOf(32));
            }
            parameters.put(key, Erasurator.maskDollar(val));
        }
    }

    private void processDeclaredMembers(ClassDescription clz) {
        ConstructorDescr[] constrs = clz.getDeclaredConstructors();
        clz.setConstructors(new ConstructorDescr[constrs.length]);
        int i = 0;
        while (i < constrs.length) {
            clz.setConstructor(i, (ConstructorDescr)this.processMember(constrs[i], false));
            ++i;
        }
        MethodDescr[] meths = clz.getDeclaredMethods();
        clz.setMethods(new MethodDescr[meths.length]);
        int i2 = 0;
        while (i2 < meths.length) {
            clz.setMethod(i2, (MethodDescr)this.processMember(meths[i2], false));
            ++i2;
        }
        FieldDescr[] flds = clz.getDeclaredFields();
        clz.setFields(new FieldDescr[flds.length]);
        int i3 = 0;
        while (i3 < flds.length) {
            clz.setField(i3, (FieldDescr)this.processMember(flds[i3], false));
            ++i3;
        }
        InnerDescr[] inners = clz.getDeclaredClasses();
        clz.setNestedClasses(new InnerDescr[inners.length]);
        int i4 = 0;
        while (i4 < inners.length) {
            clz.setNested(i4, (InnerDescr)this.processMember(inners[i4], false));
            ++i4;
        }
    }

    private void processMembers(ClassDescription clz) {
        MemberCollection newMembers = new MemberCollection();
        Iterator e = clz.getMembersIterator();
        while (e.hasNext()) {
            newMembers.addMember(this.processMember((MemberDescription)e.next()));
        }
        clz.setMembers(newMembers);
    }

    public MemberDescription processMember(MemberDescription mr) {
        return this.processMember(mr, false);
    }

    private MemberDescription processMember(MemberDescription mr, boolean dontClone) {
        String ths;
        String type;
        if (!$assertionsDisabled && mr.isClass()) {
            throw new AssertionError();
        }
        this.localParameters.clear();
        if (mr.getTypeParameters() != null) {
            Erasurator.parseTypeParameters(mr, this.localParameters);
        }
        MemberDescription cloned_m = mr;
        if (!dontClone) {
            cloned_m = (MemberDescription)mr.clone();
        }
        cloned_m.setTypeParameters(null);
        String args = cloned_m.getArgs();
        if (!"".equals(args)) {
            cloned_m.setArgs(this.convert(args, this.globalParameters, this.localParameters));
        }
        if (!"".equals(type = cloned_m.getType())) {
            cloned_m.setType(this.convert(type, this.globalParameters, this.localParameters));
        }
        if (!"".equals(ths = cloned_m.getThrowables())) {
            cloned_m.setThrowables(this.convert(ths, this.globalParameters, this.localParameters));
        }
        if (SigTest.debug) {
            String s = cloned_m.toString();
            int fl = s.indexOf(10);
            if (fl > 0) {
                s = s.substring(0, fl);
            }
            if (!($assertionsDisabled || s.indexOf(60) == -1 && s.indexOf(63) == -1 && s.indexOf(123) == -1)) {
                throw new AssertionError((Object)s);
            }
        }
        return cloned_m;
    }

    public static ArrayList splitParameters(String actualTypeParams) {
        ArrayList<String> paramList = new ArrayList<String>();
        int startPos = 1;
        int level = 0;
        int len = actualTypeParams.length() - 1;
        int i = 1;
        while (i < len) {
            switch (actualTypeParams.charAt(i)) {
                case '<': {
                    ++level;
                    break;
                }
                case '>': {
                    --level;
                    break;
                }
                case ',': {
                    if (level != 0) break;
                    paramList.add(actualTypeParams.substring(startPos, i));
                    startPos = i + 1;
                }
            }
            ++i;
        }
        paramList.add(actualTypeParams.substring(startPos, len));
        return paramList;
    }

    public static MemberDescription[] replaceFormalParameters(String fqn, MemberDescription[] members, List actualTypeParamList, boolean skipRawTypes) {
        MemberDescription[] result = new MemberDescription[members.length];
        int i = 0;
        while (i < members.length) {
            result[i] = Erasurator.replaceFormalParameters(fqn, members[i], actualTypeParamList, skipRawTypes);
            ++i;
        }
        return result;
    }

    public static Collection replaceFormalParameters(String fqn, Collection members, List actualTypeParamList, boolean skipRawTypes) {
        if (!$assertionsDisabled && actualTypeParamList.size() == 0) {
            throw new AssertionError();
        }
        ArrayList<MemberDescription> result = new ArrayList<MemberDescription>();
        Iterator it = members.iterator();
        while (it.hasNext()) {
            MemberDescription newFid = Erasurator.replaceFormalParameters(fqn, (MemberDescription)it.next(), actualTypeParamList, skipRawTypes);
            result.add(newFid);
        }
        return result;
    }

    private static MemberDescription replaceFormalParameters(String fqn, MemberDescription fid, List actualTypeParamList, boolean skipRawTypes) {
        MemberDescription newFid = (MemberDescription)fid.clone();
        int i = 0;
        while (i < actualTypeParamList.size()) {
            String actual = (String)actualTypeParamList.get(i);
            if (!skipRawTypes || actual.indexOf(37) != -1) {
                String key = "\\{" + fqn + "%" + i + "\\}";
                Erasurator.replaceFormalParameters(newFid, key, actual);
            }
            ++i;
        }
        return newFid;
    }

    private static void replaceFormalParameters(MemberDescription mr, String formalParam, String actualParam) {
        String typeParams;
        String type;
        Matcher m;
        String actual = Erasurator.maskDollar(actualParam);
        Pattern p = Pattern.compile(Erasurator.maskDollar(formalParam));
        String args = mr.getArgs();
        if (!"".equals(args)) {
            m = p.matcher(args);
            mr.setArgs(m.replaceAll(actual));
        }
        if (!"".equals(type = mr.getType())) {
            m = p.matcher(type);
            mr.setType(m.replaceAll(actual));
        }
        if ((mr.isSuperInterface() || mr.isSuperClass()) && (typeParams = mr.getTypeParameters()) != null) {
            m = p.matcher(typeParams);
            mr.setTypeParameters(m.replaceAll(actual));
        }
    }

    private static String maskDollar(String str) {
        int pos;
        String tmp = str;
        String result = "";
        do {
            if ((pos = tmp.indexOf(36)) == -1) continue;
            result = result + tmp.substring(0, pos);
            result = result + "\\$";
            tmp = tmp.substring(pos + 1);
        } while (pos != -1);
        result = result + tmp;
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$tdk$signaturetest$core$Erasurator == null ? (class$com$sun$tdk$signaturetest$core$Erasurator = Erasurator.class$("com.sun.tdk.signaturetest.core.Erasurator")) : class$com$sun$tdk$signaturetest$core$Erasurator).desiredAssertionStatus();
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$tdk$signaturetest$core$Erasurator == null ? (class$com$sun$tdk$signaturetest$core$Erasurator = Erasurator.class$("com.sun.tdk.signaturetest.core.Erasurator")) : class$com$sun$tdk$signaturetest$core$Erasurator);
        simpleParamName = Pattern.compile("^%\\d+?");
        simpleParamUsage = Pattern.compile("<[^<>]+?>");
        replaceParamUsage = Pattern.compile("\\{.+?\\}");
    }
}

