/*
 * $Id: param.h,v 1.33 1999/10/28 13:18:08 byers Exp $
 * Copyright (C) 1994-1999  Lysator Academic Computer Association.
 *
 * This file is part of the LysKOM server.
 * 
 * LysKOM is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 1, or (at your option) 
 * any later version.
 * 
 * LysKOM is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with LysKOM; see the file COPYING.  If not, write to
 * Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
 * or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
 * MA 02139, USA.
 *
 * Please mail bug reports to bug-lyskom@lysator.liu.se. 
 */
/*
 * LysKOM parameters read from the configuration file. 
 */
#ifndef PARAM_H_INCLUDED
#define PARAM_H_INCLUDED

/* See server-config.c and lyskomd.texi for more info about the
   fields in this structure. */
struct kom_par {
    char *dbase_dir;
    char *use_locale;
    Bool  send_async_messages;
    Bool  garb_enable;
    Bool  never_save;
    char *logaccess_file;
    char *ip_client_host;	/* IP to listen to (default: INADDR_ANY) */
    char *ip_client_port;       /* Port to listen to for clients */
    Conf_no conf_pres_conf;
    Conf_no pers_pres_conf;
    Conf_no motd_conf;
    Conf_no kom_news_conf;
    Text_no motd_of_lyskom;
    char *datafile_name;
    char *backupfile_name;
    char *backupfile_name_2;
    char *lockfile_name;
    char *textfile_name;
    char *textbackupfile_name;	/* Only used in dbck */
    char *backup_dir;		/* Only used in splitkomdb */
    char *statistic_name;
    char *pid_name;
    char *memuse_name;
    char *logfile_name;
    char *aux_def_file;
    char *status_file;		/* Only used in komrunning and updateLysKOM */
    char *core_dir;
    char *nologin_file;
    char *lyskomd_path;
    char *savecore_path;
    int y2k_compat;
    int timeout;
    int garbtimeout;
    int synctimeout;
    int garb_interval;
    Bool permissive_sync;
    int sync_interval;
    int sync_retry_interval;
    int saved_items_per_call;
    int client_data_len;
    int conf_name_len;
    int pwd_len;
    int what_do_len;
    int username_len;
    int text_len;
    int aux_len;
    int broadcast_len;
    int regexp_len;
    int max_marks_person;
    int max_marks_text;
    int max_recipients;
    int max_comm;
    int max_foot;
    int max_crea_misc;
    int mark_as_read_chunk;
    int accept_async_len;
    int max_delete_aux;
    int max_add_aux;
    int max_super_conf_loop;
    int default_nice;
    int default_keep_commented;
    int maxqueuedsize;
    int maxdequeuelen;
    Bool anyone_can_create_new_persons;
    Bool anyone_can_create_new_confs;
    Bool create_person_before_login;
    Bool default_change_name;
    int cache_conferences;
    int cache_persons;
    int cache_text_stats;

    /* 0=never use IDENT,
       1=try to use IDENT,
       2=only allow login if IDENT succeeded. */    
    int authentication_level;
    Bool log_login;
    Bool force_iso_8859_1;
    int no_files;		/* -1=default */
    int normal_shutdown_time;	/* In minutes. */
    int downtime_mail_start;	/* In minutes. */
    int downtime_mail_end;	/* In minutes */
    Bool invite_by_default;
    Bool secret_memberships;
    Bool allow_reinvite;
    unsigned long max_conf;
    unsigned long max_text;
};

extern struct kom_par param;
extern Bool   reread_param;
extern char  *read_config_file;

#endif
