/*
	For more information on lwm, see

		http://users.ch.genedata.com/~enh/

*/

/* --- Administrator-configurable defaults. --- */

#define DEFAULT_TITLE_FONT "-*-lucida-bold-r-normal-sans-14-*-*-*-p-*-iso8859-1"
#define DEFAULT_POPUP_FONT "-*-lucida-medium-r-normal-sans-12-*-*-*-p-*-iso8859-1"
#define DEFAULT_TERMINAL "xterm"
#define DEFAULT_BORDER 6

#define HIDE_BUTTON Button3
#define MOVE_BUTTON Button2
#define RESHAPE_BUTTON Button1

/* --- End of administrator-configurable defaults. --- */

/*
 * Window manager mode. wm is in one of three modes: it's either getting
 * user input to move/reshape a window, getting user input to make a
 * selection from the menu, or it's `idle' --- responding to events arriving
 * from the server, but not directly interacting with the user.
 * OK, so I lied: there's a fourth mode so that we can tell when wm's still
 * initialising.
 */
typedef enum {
	wm_initialising, wm_idle, wm_reshaping, wm_menu_up
} Mode;

/** Window internal state. Yuck. */
typedef enum {
	IPendingReparenting, INormal
} IState ;

/**
* Window edge, used in resizing. The `edge' ENone is used to signify a
* window move rather than a resize. The code is sufficiently similar that
* this isn't a special case to be treated separately.
*/
typedef enum {
	ETopLeft,	ETop,		ETopRight,
	ERight,		ENone,		ELeft,
	EBottomLeft,	EBottom,	EBottomRight,
	E_LAST
} Edge ;

/**
* Screen information.
*/
typedef struct ScreenInfo ScreenInfo;
struct ScreenInfo {
	Window root;
	Window popup;
	
	int display_width;		/* The width of the screen. */
	int display_height;		/* The height of the screen. */
	
	GC gc;		/* The default GC. */
	GC gc_thin;	/* The default GC but with thinner lines. */
	GC menu_gc;	/* The GC for the popup window (menu). */
	GC size_gc;	/* The GC for the popup window (sizing). */
	
	unsigned long black;		/* Black pixel value. */
	unsigned long white;	/* White pixel value. */
	unsigned long gray;		/* Gray pixel value. */
	
	Cursor root_cursor;
	Cursor frame_cursor;
	
	Cursor cursor_map[E_LAST];
	
	char * display_spec;
};

typedef struct Client Client;
struct Client {
	Window window;		/* Client's window. */
	Window parent;		/* Window manager frame. */
	Window trans;			/* Window that client is a transient for. */

	Client * next;			/* Next window in client list. */

	int border;			/* Client's original border width. */

	XSizeHints size;		/* Client's current geometry information. */
	int state;				/* Window state. See ICCCM and <X11/Xutil.h> */

	Bool hidden;			/* True if this client is hidden. */
	IState internal_state;
	int proto;

	int accepts_focus;		/* Does this window want keyboard events? */
	
	char * name;			/* Name used for title in frame. */
	char * fallback_name;	/* Name used in menu when window has no titlebar. */
	
	ScreenInfo * screen;
	
	/* Colourmap scum. */
	Colormap cmap;
	int ncmapwins;
	Window * cmapwins;
	Colormap * wmcmaps;
};


/*
 *	c->proto is a bitarray of these
 */
enum {
	Pdelete = 1,
	Ptakefocus = 2
};

/*
 * This should really have been in X.h --- if you select both ButtonPress
 * and ButtonRelease events, the server makes an automatic grab on the
 * pressed button for you. This is almost always exactly what you want.
 */
#define ButtonMask (ButtonPressMask | ButtonReleaseMask)

/*	lwm.c */
extern Mode mode;
extern int start_x;
extern int start_y;
extern Display * dpy;
extern int screen_count;
extern ScreenInfo * screens;
extern ScreenInfo * current_screen;
extern XFontStruct * font;
extern XFontStruct * popup_font;
extern Atom _mozilla_url;
extern Atom wm_state;
extern Atom wm_change_state;
extern Atom wm_protocols;
extern Atom wm_delete;
extern Atom wm_take_focus;
extern Atom wm_colormaps;
extern Atom compound_text;
extern Bool shape;
extern int shape_event;
extern char *argv0;
extern void shell(ScreenInfo *, int, int, int);
extern void sendConfigureNotify(Client *);
extern int titleHeight(void);
extern ScreenInfo * getScreenFromRoot(Window);
extern void scanWindowTree(int);

/*	client.c */
extern Edge interacting_edge;
extern Client *Client_Get(Window);
extern Client *Client_Add(Window, Window);
extern void Client_MakeSane(Client *, Edge, int *, int *, int *, int *);
extern void Client_DrawBorder(Client *, int);
extern void setactive(Client *, int, long);
extern void Client_SizeFeedback(void);
extern void size_expose(void);
extern void Client_ReshapeEdge(Client *, Edge);
extern void Client_Move(Client*);
extern void Client_SetState(Client *, int);
extern void Client_Back(Client *);
extern void Client_Close(Client *);
extern void Client_Remove(Client *);
extern void Client_FreeAll(void);
extern void Client_ColourMap(XEvent*);
extern int hidden(Client *);
extern int withdrawn(Client *);
extern int normal(Client *);
extern Client *current;

/*	cursor.c */
extern Cursor getEdgeCursor(Edge edge);
extern void initialiseCursors(int);

/*	disp.c */
extern void dispatch(XEvent *);
extern void reshaping_motionnotify(XEvent *);

/*	error.c */
extern int ignore_badwindow;
extern int errorHandler(Display *, XErrorEvent *);
extern void panic(char*);

/*	manage.c */
extern void getWindowName(Client *);
extern void getNormalHints(Client *);
extern void manage(Client *, int);
extern void withdraw(Client *);
extern void cmapfocus(Client *);
extern void getColourmaps(Client *);
extern void getTransientFor(Client *);
extern void Terminate(int);

/*	mouse.c */
extern void getMousePosition(int *, int *);
extern void hide(Client *);
extern void unhidec(Client *, int);
extern void update_menu(Client *);
extern int menu_whichitem(int, int);
extern void menuhit(XButtonEvent *);
extern void unhide(int, int);
extern void menu_expose(void);
extern void menu_motionnotify(XEvent *);
extern void menu_buttonrelease(XEvent *);

/*	shape.c */
extern int shapeEvent(XEvent *);
extern int serverSupportsShapes(void);
extern int isShaped(Window);
extern void setShape(Client *);

/*	resource.c */
extern char *font_name;
extern char *popup_font_name;
extern char *btn1_command;
extern char *btn2_command;
extern int border;
extern char * sdup(char *);
extern void parseResources(void);
