<?php
/*
    LWAT, LDAP Webbased Administration Tool
    Copyright (C) 2007  Finn-Arne Johansen <faj@bzz.no>, Bzzware AS, Norway

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/
require_once ('functions.php') ;
loadConfig () ; 
require_once ('/etc/lwat/config.php') ;
require('/usr/share/php/smarty/libs/Smarty.class.php') ; 
loadLocale () ; 
ob_start () ; 

$smarty = new Smarty();
$smarty->template_dir = $smarty_templ ; 
$smarty->compile_dir = $smarty_compile ; 

$want= array ("objectClass", "cn", "uid");
if (!($connect = ldap_connect ($ldaphost))) 
    die ("Could not connect to ldap server") ; 
ldap_set_option($connect, LDAP_OPT_PROTOCOL_VERSION, 3);
ldap_start_tls ($connect) ; 

$name=trim($_GET['username']) ; 

if (empty($name))
    $action=readKey('Action') ; 
else 
    $action="searchFor" ; 

switch ($action) {
    case "searchFor":
	if ($bind = ldap_bind ($connect)) { 
	    if (empty ($name)) {
	        $name=readKey ('name') ;
	        $filter="(&(objectClass=posixAccount)" . 
	                "(|(uid=$name*)(cn=$name*)))" ; 
	    } else
	        $filter="(&(objectClass=posixAccount)(uid=$name))" ; 
	    $result= ldap_search ($connect, $base, $filter, $want);
	    $entries = ldap_get_entries ($connect, $result);
	    switch ($entries["count"]) {
		case 0:
		    $smarty->assign('filter', $filter) ; 
		    $smarty->display('chguserpw_none.tpl');
		    break ;
		case 1:
		    $smarty->assign('userdn', $entries[0]['dn']) ; 
		    $smarty->assign('username', $entries[0]['uid'][0]) ; 
		    $smarty->assign('fullname', $entries[0]['cn'][0]) ; 
		    if (in_array("sambaSamAccount", $entries[0]["objectclass"]) === false)
		        $smarty->assign('sambaAccount', 0) ; 
		    else
		        $smarty->assign('sambaAccount', 1) ; 
		    $smarty->display('chguserpw_change.tpl');
		    break ;
		default:
		    for ($i = 1 ; $i < $entries['count']; $i++) {
		        $display[] = $entries[$i]['cn'][0] . "(" . $entries[$i]['uid'][0] . ")" ; 
		        $username[] = $entries[$i]['uid'][0] ; 
		    }
		    $smarty->assign ('display', $display) ; 
		    $smarty->assign ('username', $username) ; 
		    $smarty->display ('chguserpw_select.tpl') ; 
		    break ;
	    }
	}
        break ;
    case "setpw":
	$newpw = readKey('userpw') ; 
	$oldpw = readKey('oldpw') ; 
	$chkpw = readKey('chkpw') ; 
	if (strlen ($newpw) < $minPwLength )
	    printf (_("Sorry. The password is too short") . "<br>" );
	elseif ($newpw <> $chkpw) 
	    printf (_("Sorry. The passwords must be the same") . "<br>" );
	else {
	    $userdn = readKey('userdn') ; 
	    $cryptpw = cryptgen ($newpw); 
	    $sambahash = new smbHash ; 
	    $info = array ();
	    $info["userPassword"][] = $cryptpw ;
	    if (readkey("sambaAccount") == 1) {
	        $info["sambaLMPassword"][] = $sambahash->lmhash($newpw) ; 
	        $info["sambaNTPassword"][] = $sambahash->nthash($newpw);
            }
	    if ($bind = ldap_bind ($connect)) {
		$result= ldap_search ($connect, $base, $filter, $want);
		$entries = ldap_get_entries ($connect, $result);
		if ($entries[count] == 1) {
		    $entry = $entries[0];
		    $admindn = $entry["dn"];
		}
		$bind = ldap_bind ($connect,$userdn,$oldpw) ;
	    }
	    if (! $bind)
		printf (_("Sorry. I'm not able to connect as  %s.") . "<br>" , $userdn );
	    else {
		$result = ldap_modify ($connect,$userdn,$info) ;
		if ($result)
		    printf (_("Changed password for  %s") . "<br>" , $userdn);
		else
		    printf (_("Failed to change password for  %s.") . "<br>" ,$userdn);
	    }
	}
	break ;
    default:
        $smarty->display('chguserpw_search.tpl');
	break ;
}
    ldap_close ($connect) ; 
?>
