#!/bin/sh

#  mirrpg v. 0.0.1-pre11
#  Copyright (C) 2001 Davide Angelocola
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this library; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#  Author: Davide Angelocola <davide178@inwind.it>
#
#  TODO: add the ability to replacing the source file header  
#

copyright ()
{
  cat << EOF
/*
 * Luola - 2D multiplayer cavern-flying game
 * Copyright (C) 2002 Calle Laakkonen
 *
 * File        : $filename
 * Description : 
 * Author(s)   : Calle Laakkonen
 *
 * Luola is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Luola is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

EOF
}

for file in `find . -name "*.[ch]" -print`; do
  dir=`dirname $file`
    if test "x$dir" != "x."; then
      subdir=`basename $dir`
      grepout=`grep "Copyright" $file`

      if test "x$grepout" = "x"; then
        backup_dir="$dir/bak"

        if test ! -d $backup_dir; then
          mkdir $backup_dir
        fi

        echo $file

        filename=`basename $file`
        cp $file $backup_dir/$filename
        copyright > $file
        cat $backup_dir/$filename >> $file
      fi
    fi
  rm $backup_dir -rf	
done
