/*
 * TraceDaemon.h
 *
 * Copyright (C) 1999, 2000 Karim Yaghmour.
 *
 * This is distributed under GPL.
 *
 * Header for trace toolkit.
 *
 * History : 
 *    K.Y., 01/10/1999, Initial typing.
 *
 */

#ifndef __TRACE_DAEMON_MAIN_HEADER__
#define __TRACE_DAEMON_MAIN_HEADER__

#include <LTTTypes.h>
#include <DevCommand.h>
#include <LinuxEvents.h>
#include <RTAIEvents.h>

#include <sys/time.h>
#include <sys/types.h>

/* Number of traced events */
#if SUPP_RTAI
#define TRACE_MAX_EVENTS            TRACE_RTAI_MAX
#else
#define TRACE_MAX_EVENTS            TRACE_MAX
#endif

/* Options structure */
typedef struct _options
{
  int                ConfigDefault;      /* Use the tracing device's default configuration */
  int                SpecifyEvents;      /* Does the user want to specify the events to trace */
  trace_event_mask   EventMask;          /* The mask specifying the events to be traced */
  int                SpecifyDetails;     /* Does the user want to specify for which events he wants the details */
  trace_event_mask   DetailsMask;        /* The mask specifying for which events the details are logged */
  int                ConfigCPUID;        /* Should the CPUID be logged */
  int                ConfigPID;          /* Does the user want to log only the events belonging to a certain PID */
  int                PID;                /* The designated PID */
  int                ConfigPGRP;         /* Does the user want to log only the events belonging to a certain process group */
  int                PGRP;               /* The designated process group */
  int                ConfigGID;          /* Does the user want to log only the events belonging to a certain GID */
  int                GID;                /* The designated GID */
  int                ConfigUID;          /* Does the user want to log only the events belonging to a certain UID */
  int                UID;                /* The designated UID */
  int                ConfigSyscallDepth; /* Fetch a certain syscall depth */
  int                SyscallDepth;       /* The designated depth */
  int                ConfigSyscallBound; /* Fetch the syscall eip that fits in a certain address bounds */
  uint32_t           UpperBound;         /* The upper bound eip */
  uint32_t           LowerBound;         /* The lower bound eip */
  int                ConfigTime;         /* Should the deamon only run for a given period of time */
  struct timeval     Time;               /* Time for which daemon should run */
  char*              DeviceFileName;     /* The name of the device from which to read events */
  char*              TraceFileName;      /* Name of file used to dump raw trace */
  char*              ProcFileName;       /* Name of file contaning /proc information as of daemon's startup */
} options;

#endif  /* __TRACE_DAEMON_MAIN_HEADER__ */
