%define __spec_install_post /usr/lib/rpm/brp-compress

Summary: Linux Terminal Server Project (ltsp.org)
Name: ltsp-utils
Version: 0.25
Release: 0
Copyright: GPL
Group: Networking/Admin
BuildRoot: /tmp/ltsp-utils_rpm
BuildArch: noarch
AutoReqProv: no

%description
This package includes the following utilities for LTSP server:

  ltspadmin   For installing and managing the packages
              on an LTSP server.

  ltspcfg     For configuring the services on an LTSP server.

  ltspinfo    For querying the workstation, to learn things,
              such as which sound daemon is being used.

%prep
  #
  # Prepare the package for building on the development machine
  #

%build
  #
  # Build the package by compiling any source code, producing binaries
  # On the development machine
  #

%install
  #
  # Put the binaries where they belong on the development machine
  #

%clean
  # Cleanup after the build process on the development machine

%files
/usr/sbin/ltspadmin
/usr/sbin/ltspcfg
/usr/bin/ltspinfo

%pre
  #
  # Just before the package is installed, this script will be run
  #

%post

%changelog
* Sun Apr 16 2006 Jim McQuillan <jam@Ltsp.org>
- ltspcfg - Added another location for the kdmrc file for Kubuntu-breezy
* Sat Apr 15 2006 Jim McQuillan <jam@Ltsp.org>
- ltspcfg - Fixed detection of whether kdm is enabled
- ltspcfg - Added the 'ddns-update-style' entry to dhcpd.conf, for Fedora fc5
* Mon Apr 10 2006 Jim McQuillan <jam@Ltsp.org>
- ltaspadmin - Fixed a problem handling non-numeric version/release numbers
* Sun Apr 9 2006 Jim McQuillan <jam@Ltsp.org>
- ltspcfg - Fixed problems with GDM and KDM on both Fedora FC5 and Ubuntu
- ltspadmin - Fixed problem with missing Termcap entries
- ltspadmin - Made it handle ltspcfg croaking a little nicer.
* Tue Apr 4 2006 Jim McQuillan <jam@Ltsp.org>
- ltspcfg - Changed the content that we write to dhcpd.conf, to include
  the auto-hostname stuff.
- ltspadmin - Added support for LTSP-4.2.  Also, it looks out for older
  versions of ltsp, to make sure you can't overwrite an existing installation.
- ltspcfg - fixed the problem with xdmcp showing up as NOT enabled.
- ltspadmin - Updated the pkgformat to 0.5, to support the new LTSP-4.2
  packages.
- ltspcfg - fixed autodetection of ubuntu/Breezy, and cleaned up the
  message about portmap on Debian.
* Wed Mar 16 2005 Jim McQuillan <jam@Ltsp.org>
- Changed the default url to be: http://ltsp.mirrors.tds.net/pub/ltsp/ltsp-4.1/
- Changed it to use a package.list file, rather than downloading each .ltsp
  file separately.
* Wed Aug 25 2004 Jim McQuillan <jam@Ltsp.org>
- Added code to deal with missing perl modules more gracefully.
- Added filtering of of multiple versions of the same program,
  so that only the latest version will get installed.
* Mon Aug 16 2004 Jim McQuillan <jam@Ltsp.org>
- Fixed problem with the version number in ltspadmin. It was being
  treated as a floating point number, so 0.10 was coming out as
  0.1.  I changed it to a string, and now it appears correct.
* Fri Aug 13 2004 Jim McQuillan <jam@Ltsp.org>
- Added binmode() to the download function. This fixes problems with
  md5sum mismatches that some people were having.  Thanks to
  Scott Chapman.
- Added testing for the LWP module, along with a reasonable message
  displays if LWP is not found.
* Wed Aug 4 2004 Jim McQuillan <jam@Ltsp.org>
- Fixed LANG problem in ltspadmin. It was causing md5 mismatches
* Tue Aug 3 2004 Jim McQuillan <jam@Ltsp.org>
- Added progress indicator to download screens
* Tue Jul 27 2004 Jim McQuillan <jam@Ltsp.org>
- Fixed problem in ltspcfg where it was missing the "disable" line
  in /etc/xinetd.d/tftp.
- Added progress indicator in ltspadmin
* Tue Jul 13 2004 Jim McQuillan <jam@Ltsp.org>
- Fixed testing of root in install.sh
- Moved ltspinfo to /usr/bin, instead of /usr/sbin
* Mon Jul 12 2004 Jim McQuillan <jam@Ltsp.org>
- Added ltspinfo
- Lots of fixes to ltspcfg contributed by Emiliano Gabrielli, mostly
  for Debian things.
- Fix to the Languange environment variables, to work better internationally
* Sat Jun 26 2004 Jim McQuillan <jam@Ltsp.org>
- Fixed accumulating of component size. It wasn't zeroing the total, so
  returning to the component list window would keep adding to the total.
* Thu Jun 24 2004 Jim McQuillan <jam@Ltsp.org>
- First build of the RPM package
