// $Id: setgamma.cpp,v 1.23 2006/06/04 02:08:31 hvengel Exp $
//  Little cms Profiler
// Copyright (C) 2005 Hal Engel
//
// THIS SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
// EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
// WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
//
// IN NO EVENT SHALL MARTI MARIA BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
// INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
// OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
// WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
// LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
// OF THIS SOFTWARE.
//
// This file is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, if you
// distribute this file as part of a program that contains a
// configuration script generated by Autoconf, you may include it under
// the same distribution terms that you use for the rest of that program.
//
// Version 1.11

#include "monitorvalues.h"
#include "setgamma.h"
#include "lcmsprf.h"
#include "qtlcmswidgets.h"
// #include "lprofmain.h"
#include <qlineedit.h>
#include <qpixmap.h>
#include <wwfloatspinbox.h>

static PROFILERDATA sys; 
QButtonGroup* RGB_button_group;

monitorVal mongamma;

// static QAssistantClient *help;

QString gamma_get_QTDIR()
{
    // qDebug("get_home_dir");
    const char* qtdir= "QTDIR";
    return (QString) getenv(qtdir);
}


QString textvalue(double b)
{	
    static char Buffer[128];
    ::sprintf(Buffer, "%g", b);
    return (QString) Buffer;
}

SetGamma::SetGamma(QWidget *parent )
    : SetGammaBase(parent,"", Qt::WStyle_NoBorder)
{      
    // Take a copy of gamma
    GammaPix = new QPixmap(*(GammaProof -> pixmap()));
    GammaPix -> setOptimization(QPixmap::BestOptim);
    GammaBitmap = *GammaPix;
    Screen      = *GammaPix;
    
    ChartPix = new QPixmap(*(BigChart -> pixmap()));
    ChartPix -> setOptimization(QPixmap::BestOptim);
    ChartBitmap = *ChartPix;
    ChartScreen      = *ChartPix;
    
    mongamma.get(&mongamma);     
      
    RGB_button_group = new QButtonGroup(this);
    RGB_button_group->insert(AdjustR,0);
    RGB_button_group->insert(AdjustG,1);
    RGB_button_group->insert(AdjustB,2);
    RGB_button_group->setExclusive(TRUE);
     
    // Fill primaries combo

    if (mongamma.items.linked==1) 
    {
        CheckLinkGamma -> setChecked(true);
    }
    else	
    { 
        CheckLinkGamma -> setChecked(false);
    }
    
    GammaR -> setMinValue(1.61);
    GammaR -> setLineStep(0.01);
    GammaR -> setMaxValue(4.0);
    
    GammaG -> setMinValue(1.61);
    GammaG -> setLineStep(0.01);
    GammaG -> setMaxValue(4.0);
    
    GammaB -> setMinValue(1.61);
    GammaB -> setLineStep(0.01);
    GammaB -> setMaxValue(4.0);
    
    GammaR -> setValue(mongamma.items.rgamma);
    GammaG -> setValue(mongamma.items.ggamma);
    GammaB-> setValue(mongamma.items.bgamma);
    
    AdjustR->setChecked(mongamma.items.rchecked);
    AdjustG->setChecked(mongamma.items.gchecked);
    AdjustB->setChecked(mongamma.items.bchecked);
	
    slotChangeGamma();
    slotGammaRadio();
    slotGammaSlider();	
}

SetGamma::~SetGamma()
{
    delete RGB_button_group;
    RGB_button_group = 0;
    delete GammaPix;
    GammaPix = 0;
    delete ChartPix;
    ChartPix = 0;
}

void SetGamma::slotChangeGamma()
{
    if (CheckLinkGamma -> isChecked()) 
    {
        AdjustR -> hide();
        AdjustG -> hide();
        AdjustB -> hide();
        GammaR -> setEnabled(TRUE);
        GammaG -> hide();
        GammaB -> hide();
    }
    else 
    {
        AdjustR -> show();
        AdjustG -> show();
        AdjustB -> show();
        GammaR -> show();
        GammaG -> show();
        GammaB -> show();
        
        GammaR -> setEnabled(AdjustR -> isChecked());
        GammaG -> setEnabled(AdjustG -> isChecked());
        GammaB -> setEnabled(AdjustB -> isChecked());
    }

    slotGammaRadio();
    slotGammaSlider();
}

void SetGamma::slotGammaRadio()
{
    double v;

    if (AdjustR -> isChecked())  v = GammaR -> value();
    else 
        if (AdjustG -> isChecked()) v = GammaG -> value();
        else
            v = GammaB -> value();

    GammaSlider -> setValue((int)(v * 100));

    RenderGamma();
    ProofGamma();
}


void SetGamma::slotGammaSlider()
{
    double val = (double) GammaSlider -> value() / 100.0;

    if (CheckLinkGamma -> isChecked()) 
    {
        // set all three values
        GammaR -> setValue(val);
        GammaG-> setValue(val);
        GammaB -> setValue(val);
    }
    else 
    {
        if (AdjustR -> isChecked())
            GammaR -> setValue(val);
        else
            if (AdjustG -> isChecked())
                GammaG -> setValue(val);
        else
            // if (AdjustB -> isChecked())
                GammaB -> setValue(val);
    }
    
    RenderGamma();
    ProofGamma();
}

void SetGamma::RenderGamma()
{
    
    const double offset = -1.25;
    
    if (sys.Prelinearization[0]) cmsFreeGamma(sys.Prelinearization[0]);
    
    if (sys.Prelinearization[1]) cmsFreeGamma(sys.Prelinearization[1]);
    
    if (sys.Prelinearization[2]) cmsFreeGamma(sys.Prelinearization[2]);
    
    if (CheckLinkGamma -> isChecked()) 
    {
        double val = GammaR -> value() + offset; 
        // the -1.25 is an offset to make this work with the Norman Koren gamma chart
        // This has now been checked on an instrument calibrate display 
        // and appears to be giving correct results.
        
        sys.Prelinearization[0] = cmsBuildGamma(256, val);
        sys.Prelinearization[1] = cmsBuildGamma(256, val);
        sys.Prelinearization[2] = cmsBuildGamma(256, val);
    }
    else 
    {
        sys.Prelinearization[0] = cmsBuildGamma(256, GammaR -> value() + offset);
        sys.Prelinearization[1] = cmsBuildGamma(256, GammaG -> value() + offset);
        sys.Prelinearization[2] = cmsBuildGamma(256, GammaB -> value() + offset);
    } 

}


LPGAMMATABLE Gamma;
DWORD dwMask; 

void SetGamma::Set_dwMask_Gamma ()
{ 
   
    if (CheckLinkGamma -> isChecked()) 
    {
        Gamma = cmsReverseGamma(256, sys.Prelinearization[0]);
        dwMask = 0x00FFFFFF;
    }
    else
        if (AdjustR -> isChecked()) 
        {
            Gamma = cmsReverseGamma(256, sys.Prelinearization[0]);
            dwMask = 0x00FF0000;
        }
    else
        if (AdjustG -> isChecked()) 
        {
            Gamma = cmsReverseGamma(256, sys.Prelinearization[1]);
            dwMask = 0x0000FF00;
        }
    else 
    {
        Gamma = cmsReverseGamma(256, sys.Prelinearization[2]);
        dwMask = 0x000000FF;
    }
}

void SetGamma::Gamma_loop (QImage in, QImage out/*, BOOL LittleEndian */)
{
    L16PARAMS Lut16;
    cmsCalcL16Params(Gamma -> nEntries, &Lut16);
    int height = out.height();
    int width  = out.width();
    
    
    for (int i=0; i < height; i++) 
    {
        for (int j=0; j < width; j++) 
        {   
            // get rgb value and shift it to eliminate alpha channel
            QRgb InVal = (in.pixel(j, i) << 8); 
            // apply the gamma curve 
            uint OutVal = cmsLinearInterpLUT16(InVal , Gamma -> GammaTable, &Lut16);
            //  Only interested in one byte since image is gray
            DWORD OutByte = (DWORD) (OutVal >> 8);
            DWORD Out = OutByte;
            // shift that byte into all three channels
            OutByte <<= 8;
            Out |= OutByte;
            OutByte <<= 8;
            Out |= OutByte;
            // mask only those channels needed
            Out &= dwMask;
            // Add alpha channel and move to output pixmap
            out.setPixel( j, i, (QRgb) (Out | 0xFF000000));
         }
     }  
     
}

   


void SetGamma::ProofGamma()
{    
    
    Set_dwMask_Gamma (); 

    Gamma_loop (GammaBitmap, Screen); 
    ScreenPixmap.convertFromImage(Screen, QPixmap::ColorOnly | QPixmap::ThresholdDither | QPixmap::AvoidDither);
    GammaProof -> setPixmap(ScreenPixmap);

    Gamma_loop (ChartBitmap, ChartScreen);
    ChartScreenPixmap.convertFromImage(ChartScreen, QPixmap::ColorOnly | QPixmap::ThresholdDither | QPixmap::AvoidDither);
    BigChart -> setPixmap(ChartScreenPixmap);

    cmsFreeGamma(Gamma);
    
}

void SetGamma::slotOK()
{
    // qDebug("In slot OK");
 
    if (CheckLinkGamma -> isChecked()) 
    {
        mongamma.items.linked=1;
    }
    else 	
    {
        mongamma.items.linked=0;
    }
    
    mongamma.items.rgamma=GammaR -> value();
    mongamma.items.ggamma=GammaG -> value();
    mongamma.items.bgamma=GammaB -> value();
    mongamma.items.rchecked=AdjustR->isChecked();
    mongamma.items.gchecked=AdjustG->isChecked();
    mongamma.items.bchecked=AdjustB->isChecked();
    mongamma.put(mongamma);
}

void SetGamma::slotHelpButton()
{
     
     QString path = QDir::currentDirPath() + "/help/gamma.html";
     getHelp()->openAssistant ();
     getHelp()->showPage(path);
}


