Summary: Red Hat print filters, for use with the printtool.
Name: rhs-printfilters
Version: 1.81
Release: 1
Copyright: GPL
Group: Applications/Publishing
Source: rhs-printfilters-%{version}.tar.gz
Requires: mpage >= 2.4, LPRng, ghostscript >= 5.10, findutils >= 4.1-23, diffutils, sed, fileutils
Buildroot: %{_tmppath}/%{name}-root
BuildPrereq: transfig
#
# these conflcts exists because Dr Mike changes the location of the filters
#
Conflicts: libgr-progs < 2.0.9-7

%description
The rhs-printfilters package contains a set of print filters which are
primarily meant to be used with the Red Hat printtool.  These print
filters provide an easy way for users to handle printing numerous file
formats.

%prep
%setup -q

%build

%install
rm -rf $RPM_BUILD_ROOT

mkdir -p INSTALL_DIR=$RPM_BUILD_ROOT/usr/lib/rhs/rhs-printfilters
make INSTALLBIN="install -m0755" INSTALLDATA="install -m0644" \
	INSTALL_DIR=$RPM_BUILD_ROOT install

%clean 
rm -rf $RPM_BUILD_ROOT

%pre
# Requires:
# bash, sed, grep, ln, diff, rm, cat
# Where is the printcap?
PRINTCAP='/etc/printcap'
# Where is the master filter?
MASTER_FILTER='/usr/lib/rhs/rhs-printfilters/master-filter'
# Make sure that we actually have these files
if [ -f $PRINTCAP ] && [ -f $MASTER_FILTER ]
then
# Open printcap
cat $PRINTCAP | (
	# Read each line (forcing it to ignore the '\' convention).
	while read -r line;
	do
		# if a line looks like ':if=filename:', but aint commented,
		if echo ${line} | grep -q -E -e '^[^#]{0}[[:space:]]*:if='
		then
			# strip it down to the file name,
			# (We can be a little messy, 'cause printcap uses
			# ':' as a control character, to it can't be in
			# the file name)
			FILTER=`echo ${line} | sed -e 's/^:if=//; s/:.*//'`
			# and if the filter it names is the same as the
			# master-filter then
			if diff $MASTER_FILTER $FILTER > /dev/null
			then
				# remove the named filter, and replace it
				rm -f $FILTER
				# with a symlink to the master filter
				ln -s $MASTER_FILTER $FILTER
			fi
		fi
	done
)
fi

%files
%defattr(-,root,root)
%doc README CHANGES
%dir /usr/lib/rhs/rhs-printfilters
/usr/lib/rhs/rhs-printfilters/asc-to-printer.fpi
/usr/lib/rhs/rhs-printfilters/asc-to-ps.fpi
/usr/lib/rhs/rhs-printfilters/general.cfg.in
/usr/lib/rhs/rhs-printfilters/master-filter
/usr/lib/rhs/rhs-printfilters/postscript.cfg.in
%config(noreplace) /usr/lib/rhs/rhs-printfilters/printerdb
/usr/lib/rhs/rhs-printfilters/ps-to-printer.fpi
/usr/lib/rhs/rhs-printfilters/rpm-to-asc.fpi
/usr/lib/rhs/rhs-printfilters/ncpprint
/usr/lib/rhs/rhs-printfilters/ppaprint
/usr/lib/rhs/rhs-printfilters/smbprint
/usr/lib/rhs/rhs-printfilters/directprint
/usr/lib/rhs/rhs-printfilters/testpage.asc
/usr/lib/rhs/rhs-printfilters/testpage.ps
/usr/lib/rhs/rhs-printfilters/testpage-a4.ps
/usr/lib/rhs/rhs-printfilters/textonly.cfg.in

%changelog
* Wed Aug 30 2000 Crutcher Dunnavant <crutcher@redhat.com>
- changed the master-filter so that it can extract all the normal
- file format actions, and thus print the 'l' action, resolves bug #16986 

* Fri Aug 18 2000 Crutcher Dunnavant <crutcher@redhat.com>
- added magic to the pre-install that examines the printcap (if it exists)
- and compares active filters it finds there to the master filter of the
- existing rhs-printfilters (if it exists), and if they are the same,
- replaces the filter with a symlink to the master-filter.

* Mon Aug 14 2000 Crutcher Dunnavant <crutcher@redhat.com>
- Actually Cleaned up the Lexmark57000 entries
- (I had overlooked a spelling error in a keyword,
- that had not BEEN a problem because the entry was being
- overwritten by the second driver, but when I fixed the
- conflict, it flared up)

* Mon Aug 14 2000 Crutcher Dunnavant <crutcher@redhat.com>
- Cleaned up the Lexmark57000 entries (yes, there are two drivers.)

* Wed Aug  9 2000 Crutcher Dunnavant <crutcher@redhat.com>
- Taught master-filter's magic about 'png' files

* Thu Aug  3 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Add cdj880, cdj890 and hpdj driver support to printerdb (Bug #13312 etc)

* Fri Jul 21 2000 Nalin Dahyabhai <nalin@redhat.com>
- Fix mismatch between testpage.asc and printtool (#13111)

* Fri Jul 14 2000 Nalin Dahyabhai <nalin@redhat.com>
- Fix master-filter for use with LPRng.
- Add support for bzip2-compressed files to master-filter.

* Mon Jul 10 2000 Bill Nottingham <notting@redhat.com>
- pnm2ppa updates from the pnm2ppa sourceforge people

* Mon Jul 10 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Fix Lexmark 5700 entry (Bug #13482)

* Fri Jun 23 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Add AppleTalk bridge support, adapted from patch in Bug #11377

* Thu Jun 22 2000 Preston Brown <pbrown@redhat.com>
- added samsung printerdb entries
 
* Sat Jun 17 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Fix printerdb entry for Lexmark 5700m (Bug #12080)
- Fix some more printerdb oddities (Bug #11561)

* Fri May  5 2000 Bill Nottingham <notting@redhat.com>
- fix compilation with new transfig

* Thu Apr 20 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Fix some typos in printerdb

* Wed Apr 19 2000 Bill Nottingham <notting@redhat.com>
- add directprint file. *oops*

* Mon Feb 28 2000 Bill Nottingham <notting@redhat.com>
- add a couple more lexmarks now in gs5.50

* Thu Feb 17 2000 Bill Nottingham <notting@redhat.com>
- fix wrong driver for laserjet plus

* Mon Feb 14 2000 Bill Nottingham <notting@redhat.com>
- ooops, put ppaprint in the filelist
- add some gs-5.50 mappings

* Fri Feb 11 2000 Bill Nottingham <notting@redhat.com>
- pnm2ppa support
- fix problem with rewindstdin

* Wed Jan 26 2000 Bill Nottingham <notting@redhat.com>
- add stylus color 740 to printerdb

* Mon Nov  8 1999 Bill Nottingham <notting@redhat.com>
- revert ps-to-printer tempfile usage. There has
  to be a better way to do this.

* Wed Jul 21 1999 Bill Nottingham <notting@redhat.com>
- munge smbprint Yet Again(tm)

* Thu Jul  8 1999 Bill Nottingham <notting@redhat.com>
- make printerdb config(noreplace)

* Thu Jul  1 1999 Bill Nottingham <notting@redhat.com>
- add more drivers

* Fri Jun 18 1999 Bill Nottingham <notting@redhat.com>
- fix rpm printing

* Mon Jun 14 1999 Bill Nottingham <notting@redhat.com>
- use smbclient's -c command. Makes much more sense.

* Mon May 24 1999 Bill Nottingham <notting@redhat.com>
- hmm. The translate option went away at some point. Oops.

* Mon May  3 1999 Bill Nottingham <notting@redhat.com>
- yet another typo in SMB stuff. Urg.

* Mon Apr  5 1999 Bill Nottingham <notting@redhat.com>
- strip binaries

* Thu Apr  1 1999 Bill Nottingham <notting@redhat.com>
- fix some printerdb stuff for ghostscript brokenness

* Fri Mar 19 1999 Bill Nottingham <notting@redhat.com>
- remove some oboslete text

* Mon Feb  8 1999 Bill Nottingham <notting@redhat.com>
- uniprint support

* Tue Dec 29 1998 Bill Nottingham <notting@redhat.com>
- add workaround for Adobe(!) postscript driver

* Mon Dec 28 1998 Bill Nottingham <notting@redhat.com>
- remove 1bpp from cdj-based drivers, 'cos it's broken.

* Wed Nov 18 1998 Bill Nottingham <notting@redhat.com>
- add workgroup support to smbprint, fix quoting issues

* Wed Sep 30 1998 Bill Nottingham <notting@redhat.com>
- fix typo in ncpprint

* Wed Sep 15 1998 Bill Nottingham <notting@redhat.com>
- Added ncpprint to %files section (oops!)

* Thu Sep  2 1998 Bill Nottingham <notting@redhat.com>
- Added NCP printing support

* Tue Jun 30 1998 Michael Maher <mike@redhat.com>
- Fixed BUG 703,  added findutils dependecy.
- Added buildroot.

* Fri May 08 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Wed Oct 22 1997 Michael Fulbright <msf@redhat.com>
- Fixed printerdb to include 300x300 resolution for LaserJet 4 models
- Restored troff file handling now troff fpi is 'safe'

* Tue Oct 14 1997 Michael Fulbright <msf@redhat.com>
- Fixed master-filter to NOT handle troff files automatically

* Thu Jul 31 1997 Erik Troan <ewt@redhat.com>
- built against glibc

* Wed Apr 23 1997 Michael Fulbright <msf@redhat.com>
- Fixed problem with asc-to-printer.fpi not handling cr/lf trans correct

* Fri Apr 18 1997 Michael Fulbright <msf@redhat.com>
- fixed up Canon 600/4000 printerdb def
- added some HP Deskjets which I know work

* Thu Apr 10 1997 Michael Fulbright <msf@redhat.com>
- Added requirement that gs is installed. Pretty useless w/o it if
  you print anything interesting.

* Fri Mar 13 1997 Michael Fulbright <msf@redhat.com>
- Added conflicts so that packages with old filter loc won't hurt us.
- Moved to version 1.2.
- Added mpage support to allow nup printing.

* Wed Mar 13 1997 Michael Fulbright <msf@redhat.com>
- Added a DeskJet500Mono driver which links to the gs driver djet500.
- Added a A4 paper size test page.
- Fixed Makefile to build .ps test pages from the .fig files.

* Mon Mar 10 1997 Michael Fulbright <msf@redhat.com>
- Split filters off from printtool into this package .
