from shellprocess import *
from utils import *
from CDROM import *


# ffmpeg -i image%06d.jpg -maxrate 1152 -bufsize 20 -r 29.92 -s 352X240 -f mpeg1video test.mpg
# ffmpeg -i image%06d.jpg -r 25 -maxrate 1152 -bufsize 20 -f mpeg1video -sameq -pass 2 -passlogfile mpg.txt test.mpg		
# vcdmplex test.mpg ../test.mp2 out.mpg
# mkvcdfs out.mpg
# cdrdao write --device 0,0,0 --driver generic-mmc vcd.toc
# ffmpeg -i image%06d.jpg -i '/root/My Documents/Come To This.mp3' -r 25 -b 1152 -ab 224 -target vcd -sameq
	
class LffmpegProcess(LShellProcess):
	def __init__(self, dir,  format, frames=0, imgPatter="image%d.jpg", outFile="video.mpg", audioFile=None):
		LShellProcess.__init__(self)
		self.dir = dir
		self.imgPattern = str(self.quote(str(os.path.join(dir, imgPatter))))
		self.outFile = str(self.quote(str(os.path.join(dir, outFile))))
		self.frames = frames
		self.framePattern = re.compile(r"frame\=[ |\t]*(\d+)[ |\t]q=")
		self.convertLineEndings = True
		self.audioFile = audioFile and str(self.quote(audioFile)) or None
		self.format = format
		
	def buildCommand(self):			
		self.setExecutable('nice')
		args = ['ffmpeg',
				'-i',self.imgPattern,
				'-r',str(self.format['fps']),
				'-b',str(self.format['br']),
##~ 				'-t',str(self.frames/self.format['fps']),
##~ 				'-f',self.format['codec'],
				'-qscale','1']
				
		if self.audioFile and len(self.audioFile):
			args += ['-i', self.audioFile,
					 '-ab', '224']
					 
		args += ['-target',self.format['format'],
				 self.outFile]
	
		self.setArguments(args)
		print "% "," ".join(args)
	
	def processLines(self,lines):
		# frame=  885 q=0.0 Lsize=    1244kB time=35.4 bitrate= 288.2kbits/s
		for line in lines:
##~ 			print "*",line
			mo = self.framePattern.search(line)
			if mo:
##~ 				print "FRAME %d PERCENT %d4" % (int(mo.group(1)), (int(mo.group(1))*100/self.frames))
				self.emit(PYSIGNAL('status'), (int(mo.group(1)), self.frames))
				
class LmkvcdfsProcess(LShellProcess):
	def __init__(self, dir, inFile="video.mpg"):
		LShellProcess.__init__(self)
		self.dir = dir
		self.inFile = inFile
		
	def buildCommand(self):			
		self.setExecutable('nice')
		os.chdir(self.dir)
		args = ['vcdimager',self.inFile]
		self.setArguments(args)
		print "% "," ".join(args)

class LcdrecordProcess(LShellProcess):
	#cdrdao simulate -n -v 1 --device 0,0,0 --driver generic-mmc --eject vcd.toc
	def __init__(self, device, dir, tocFile="videocd.cue", dataFile="videocd.bin", dummy = False):
		LShellProcess.__init__(self)
		self.device = device
		self.tocFile = str(self.quote(os.path.join(dir, tocFile)))
		self.dataFile = str(self.quote(os.path.join(dir, dataFile)))
		self.dummy = dummy
		self.convertLineEndings = True
		self.dir = dir
		#Track 02:    0 of    4 MB written
		self.pattern = re.compile(r"Track 02:\s*(\d+)\s*of\s*(\d+)")

	def buildCommand(self):
		self.setExecutable('nice')
		args = ['cdrecord',
				'dev=',self.device['Address'],
				'gracetime=2',
				'cuefile=',self.tocFile,
				'-dao','-v','-eject'
				]
		if self.dummy:
			args.append("-dummy")
		self.setArguments(args)
		print "% "," ".join(args)
			
	def processLines(self,lines):
		for line in lines:
			mo = self.pattern.search(line)
			if mo:
				self.emit(PYSIGNAL('status'), (int(mo.group(1))+1, int(mo.group(2))+1))


class LcdrdaoProcess(LShellProcess):
	#cdrdao simulate -n -v 1 --device 0,0,0 --driver generic-mmc --eject vcd.toc
	def __init__(self, device, dir, tocFile="videocd.cue", dataFile="videocd.bin", dummy = False):
		LShellProcess.__init__(self)
		self.device = device
		self.tocFile = str(self.quote(os.path.join(dir, tocFile)))
		self.dataFile = str(self.quote(os.path.join(dir, dataFile)))
		self.dummy = dummy
		self.convertLineEndings = True
		self.dir = dir

		self.pattern = re.compile(r"Wrote (\d+) of (\d+)")
		
	def buildCommand(self):	
		os.chdir(self.dir)
		self.setExecutable('nice')
		args = ['cdrdao',
				self.dummy and 'simulate' or 'write',
				'-n', '--eject',
				'--device', self.device['Address'],
				'--driver', 'generic-mmc',
				self.tocFile]				
		self.setArguments(args)
		print "% "," ".join(args)
	
	def processLines(self,lines):
		# frame=  885 q=0.0 Lsize=    1244kB time=35.4 bitrate= 288.2kbits/s
		for line in lines:
			print "*",line
			mo = self.pattern.search(line)
			if mo:
				self.emit(PYSIGNAL('status'), (int(mo.group(1)), int(mo.group(2))))
				

_imgPattern = "image%d.jpg"
class LVCDDialog(QDialog):
	def __init__(self, lib, albumPath):
		QDialog.__init__(self)
		self.lib = lib
		self.albumPath = albumPath
				
		self.processQueue = None
		
		self.__widgetLayout()
		
		QObject.connect(self.burnButton, SIGNAL("clicked()"), self, SLOT("accept()"))
		QObject.connect(self.cancelButton, SIGNAL("clicked()"), self, SLOT("reject()"))
		QObject.connect(self.durationSpin, SIGNAL("textChanged(const QString &)"), self.updateEstimatedSize)
		QObject.connect(self.titleEdit, SIGNAL("textChanged(const QString &)"), self.updateEstimatedSize)
		QObject.connect(self.formatCombo, SIGNAL("activated(int)"), self.updateEstimatedSize)
		QObject.connect(self.audioPathButton, SIGNAL("clicked()"), self.getAudioPath)

		self.__loadVideoFormats()
		
		
		self.__serialize(True)
		
		self.titleEdit.setText(lib.getAlbum(albumPath)['AlbumName'])
		self.updateEstimatedSize()
		
		self.devices = CDROMS().burnerInfo()
		for d in self.devices:
			self.burnerCombo.insertItem(d['Manufacturer']+" "+d['Model'])

		self.dir = str(os.path.join(self.lib.libraryPath(),"vcd"))	
		LUtils.ensureDirectory(self.dir)
		
		if len(self.devices) == 0:
			self.burnButton.setDisabled(True)
			self.burnerCombo.insertItem(i18n("No Burners Found!"))
			
	def __widgetLayout(self):
		vl = QVBoxLayout(self, 10)
		gl = QGridLayout(vl, 7, 2)
		
		# options
		l = QLabel(i18n("Title:"), self)
		gl.addWidget(l,0,0)
		l = QLabel(i18n("Soundtrack:"), self)
		gl.addWidget(l,1,0)
		l = QLabel(i18n("Disc Format:"), self)
		gl.addWidget(l,3,0)
		l = QLabel(i18n("Burner:"), self)
		gl.addWidget(l,5,0)
		
		self.titleEdit = QLineEdit(self)
		gl.addWidget(self.titleEdit,0,1)
		self.setCaption(i18n("Burn Video CD"))

		hl = QHBoxLayout()
		gl.addLayout(hl, 1, 1)
		self.audioEdit = QLineEdit(self)
		hl.addWidget(self.audioEdit)		
		
		
		


		self.audioPathButton = QPushButton("...", self)
		hl.addWidget(self.audioPathButton)
		
		hb = QHBoxLayout()
		l = QLabel(i18n("Display each image for: "), self)
		hb.addWidget(l)
		self.durationSpin = QSpinBox(self)
		self.durationSpin.setRange(0, 10 * 60) 
		hb.addWidget(self.durationSpin)
		l = QLabel(i18n("seconds"),self)
		hb.addWidget(l)
		hb.setStretchFactor(l, 5)
		gl.addMultiCellLayout(hb, 2, 2, 0, 1)
		
		self.formatCombo = QComboBox(self)
		gl.addWidget(self.formatCombo, 3, 1)
		
		l = QLabel(i18n("Choose VCD for best compatibility with DVD players.  Choose SVCD for better quality images.  Not all DVD players can play VCDs or SVCDs."), self)
		l.setAlignment(Qt.WordBreak)
		gl.addWidget(l, 4, 1)

		self.burnerCombo = QComboBox(self)
		gl.addWidget(self.burnerCombo, 5, 1)
		
		self.sizeLabel = QLabel("", self)
		gl.addWidget(self.sizeLabel, 6, 1)
		gl.addRowSpacing(5, 40)

		# dialog buttons
		hl = QHBoxLayout(self)
		
		vl.addSpacing(20)

		vl.addStretch()
		vl.addLayout(hl)
		
		hl.addStretch()
		self.burnButton = QPushButton(i18n("Burn VCD..."), self)
		hl.addWidget(self.burnButton)
		self.burnButton.setDefault(True)
		hl.addSpacing(5)
		self.cancelButton = QPushButton(i18n("Cancel"), self)
		hl.addWidget(self.cancelButton)
		
		
	def __loadVideoFormats(self):
		self.formats = [
		[i18n('VCD (Best Compatibilty, Lowest Quality)'),
			{'size':QSize(352,288), 
			'fps':25, 
			'br':1150,
			'codec':'mpeg1video',
			'format':'vcd'}],
		[i18n('SVCD (Good Quality, Good Compatiblity)'),
			{'size':QSize(576,480), 
			'fps':25, 
			'br':2500,
			'codec':'mpeg2video',
			'format':'svcd'}]
##~ 		[i18n('XVCD (High Quality)'),
##~ 			{'size':QSize(720,576), 
##~ 			'fps':25, 
##~ 			'br':2500,
##~ 			'codec':'mpeg2video',
##~ 			'format':'svcd'}],
##~ 		[i18n('DVCD (Best Quality, Shortest Duration)'),
##~ 			{'size':QSize(720,576), 
##~ 			'fps':25, 
##~ 			'br':8000,
##~ 			'codec':'mpeg2video',
##~ 			'format':'dvd'}],
		]
		
		for i in self.formats:
			self.formatCombo.insertItem(i[0])
					
	def updateEstimatedSize(self):
		# estimated size = total frames / fps * br (bytes)
		# if size > 650 print in red
		title = self.titleEdit.text()
		
		l = len(self.lib.getAlbum(self.albumPath)['KeyList'])
		if title and len(title):
			l = l + 1
		t = self.durationSpin.text()
		if t and len(t):
			dur = int(str(t))
		else:
			self.sizeLabel.setText(i18n("Enter a duration"))
			return
			
		trd = 1 # duration of transition
		
		secs = (trd + dur) * l + trd # total seconds of movie
	
		format = self.formats[self.formatCombo.currentItem()][1]
		
		b = (format['br'] + 224)* secs * 1000/8
		
		self.sizeLabel.setText(u"%s %s" % (i18n("Estimated Size: "), LUtils.humanByteOutput(b)))

		
	def __serialize(self, bRestore):
		self.lib.serializeAlbumRange(self.albumPath, self.durationSpin, "VCD", "duration", bRestore, "4") 
		self.lib.serializeAlbumEdit(self.albumPath, self.audioEdit, "VCD", "audio", bRestore)
		self.lib.serializeAlbumCombo(self.albumPath, self.formatCombo, "VCD", "format", bRestore)
		
	def ensureMedia(self, devInfo):
		drive = devInfo['Drive']
		if not drive:
			return False

		while not drive.checkForWriteableMedia():
			drive.ejectMedia()
			if KMessageBox.warningContinueCancel(self, i18n("Please insert a blank CDR disc."), i18n("CDR Media")) == KMessageBox.Continue:
				continue
			else:
				return False
		return True
	
	def getAudioPath(self):
		path = KFileDialog.getOpenFileName(self.audioEdit.text(), "*.mp3", self, i18n("Select an mp3 file"))
		if path:
			self.audioEdit.setText(path)


	def burn(self):
		self.__serialize(False)
		self.progress = QProgressDialog(i18n("Create VCD"),i18n("Cancel"),100,None,"progress",True)
		self.progress.setAutoClose(False)
		self.progress.setAutoReset(False)
		
		self.progress.setLabelText(i18n("Checking CDR Media"))
		self.progress.setCaption(i18n("Burn VCD"))
		self.progress.show()
		
		d = self.devices[self.burnerCombo.currentItem()]
		
		if not d or not self.ensureMedia(d):
			self.cancel()
			return
		
		format = self.formats[self.formatCombo.currentItem()][1]
				
		dur = int(str(self.durationSpin.text()))
		if dur < 1:
			dur = 4
		
		QObject.connect(self.progress, SIGNAL("cancelled()"), self.cancel)
		
		self.__cleanFiles(self.dir, [".jpg",".mp3",".mpg"])
		frames = self.__makeSequence(self.dir, self.lib.getAlbum(self.albumPath)['KeyList'], self.progress, dur, format['size'], format['fps'])
		
		if not frames:
			self.cancel()
			return
		
		audioFile = str(self.audioEdit.text())
		if len(audioFile) == 0:
			audioFile = None
		# if soundfile, make sure soundfile is longer than video
		else:
			secs = self.__findFileLength(audioFile)
			if secs:
				print "video len", frames / float(format['fps']),"audio len",secs
				c = frames / float(format['fps']) / secs
				print "files needed",c," int",int(c+1.0)
				if c > 1.0:
					i = int(c+1.0)
					catFile = str(os.path.join(self.dir, "audio.mp3"))
					self.__concatenateFile(catFile, audioFile, i)
					audioFile = catFile
			else:
				audioFile = None
		
		# copy images
		l = [{
				'label':i18n("Encoding Frames..."),
				'process': lambda : LffmpegProcess(self.dir, format, frames, audioFile=audioFile),
				'cleanup': lambda : self.__cleanFiles(self.dir, [".jpg",".mp3"])
			},
			{
				'label':i18n("Building VCD Image..."), 
				'process':lambda : LmkvcdfsProcess(self.dir),
				'cleanup':lambda : self.__cleanFiles(self.dir, [".mpg"])
			},
			{
				'label':i18n("Burning VCD Disc..."), 
				'process':lambda : LcdrdaoProcess(d, self.dir),
				'postlabel':i18n("Finalizing Disc. Please Wait..."),
				'cleanup':lambda : self.__cleanFiles(self.dir, [".cue",".bin"])
			}]
			
##~ ##~ 			 (i18n("Burning VCD Disc..."), lambda : LcdrecordProcess(d, self.dir))
				
		self.processQueue = LProcessQueue(l)
		
		QObject.connect(self.processQueue, PYSIGNAL("status"), self.progress.setProgress)
		QObject.connect(self.processQueue, PYSIGNAL("newstep"), self.progress.setLabelText)
		QObject.connect(self.processQueue, PYSIGNAL("complete"), self.complete)
		QObject.connect(self.processQueue, PYSIGNAL("abort"), self.abort)
		
		self.processQueue.run()
		
	def __cleanFiles(self, dir, exts):
		[ os.remove(os.path.join(dir, f))
			for f in os.listdir(dir) 
			if os.path.splitext(f)[1].lower() in exts ]
				
	def __cleanDir(self, dir):
		[ os.remove(os.path.join(dir, f))
			for f in os.listdir(dir)
			if not os.path.isdir(f) ]

	def __makeSequence(self, dir, keys, progress, dur=4, size=QSize(352,288), fps=25):		
		import os

		title = self.titleEdit.text()
		
		imageBlack = self.__buildTitleImage("", size)
		
		transFrames = fps
		stillFrames = fps * dur - 1
		totalFrames = (transFrames + stillFrames + 1) * len(keys) + transFrames
		
		progress.setLabelText(i18n("Creating Frames..."))
		progress.setTotalSteps(totalFrames)
		progress.setProgress(0)
			
		image = None
		framePath = None
		fi = 0 # frame index
		
		if title:
			# create title sequence
			totalFrames = (transFrames + stillFrames + 1) * (len(keys) + 1) + transFrames
			progress.setTotalSteps(totalFrames)
			imageTitle = self.__buildTitleImage(title, size)
			#fade in from black
			for j in xrange(transFrames):
				LUtils.blendImages(imageBlack, imageTitle, j/float(transFrames-1), os.path.join(dir,"image%d.jpg"%(fi+j)))
				if progress.wasCancelled():
					return None
				progress.setProgress(j)
			# create still title fames
			fi = transFrames
			framePath = os.path.join(dir, _imgPattern%(fi-1))
			for j in xrange(fi, fi + stillFrames + 1):
				os.symlink(framePath, os.path.join(dir, _imgPattern%(j)))
				if progress.wasCancelled():
					return None
				progress.setProgress(j)
			fi = fi + stillFrames + 1
			
			imageOld = imageTitle
		else:
			imageOld = imageBlack
			
		for key in keys:
			if progress.wasCancelled():
				return None
			dict = self.lib.getImage(key)	
			if imageOld: # load next image and build transition images
				endTransIndex = fi + transFrames # place the next image after then transition
				framePath = os.path.join(dir,_imgPattern%(endTransIndex))
				w,h,image = LUtils.resizeImage(dict['ImagePath'], framePath, size)
				# build transition sequence
				for j in xrange(transFrames):
					LUtils.blendImages(imageOld, image, j/float(transFrames-1), os.path.join(dir,"image%d.jpg"%(fi+j)))
					if progress.wasCancelled():
						return None
					progress.setProgress(j+fi+1)
				fi = fi + transFrames + 1 # set frame index to after the new image
			else: # first image, just set this at the frame index
				framePath = os.path.join(dir,_imgPattern%(fi))
				w,h,image = LUtils.resizeImage(dict['ImagePath'], framePath, size)
				fi = fi + 1
			# build still sequence
			for j in xrange(fi, fi + stillFrames):
				os.symlink(framePath, os.path.join(dir, _imgPattern%(j)))
				if progress.wasCancelled():
					return None
				progress.setProgress(j)
			fi = fi + stillFrames
			imageOld = image

		# fade last image to black
		for j in xrange(transFrames):
			LUtils.blendImages(image, imageBlack, j/float(transFrames-1), os.path.join(dir,"image%d.jpg"%(fi+j)))
			if progress.wasCancelled():
				return None
			progress.setProgress(j)
		fi = fi + transFrames
		
##~ 		# make a second of black because sometimes the encoding wants some extra frames, but don't include these in the frame count
##~ 		framePath = os.path.join(dir, _imgPattern%(fi-1))
##~ 		for j in xrange(fi, fi + stillFrames + 1):
##~ 			os.symlink(framePath, os.path.join(dir, _imgPattern%(j)))
			
		print "TotalFrames",fi,"Estimated",totalFrames

		return fi
						
	def complete(self):
		print "COMPLETE"
		self.emit(PYSIGNAL("complete"), (self, 0))
		self.progress.close()
		KMessageBox.information(self, i18n("Your VCD is complete."))
		
	def cancel(self):
		print "CANCEL"
		self.__cleanDir(self.dir)
		if self.progress:
			self.progress.close()
			self.progress = None
		if self.processQueue:
			self.processQueue.kill()
			self.processQueue=None
		self.emit(PYSIGNAL("complete"), (self, -1))
			
	def abort(self):
		print "ABORT"
		# cleanup dir
		KMessageBox.error(self, i18n("Your VCD was not created."))
		self.cleandir(self.dir)
		self.progress.close()
		self.emit(PYSIGNAL("complete"), (self, -1))
	
	def __buildTitleImage(self, title, size):
		p = QPixmap(size)
		painter = QPainter(p)
		painter.setBackgroundColor(QColor(0,0,0))
		painter.eraseRect(p.rect())
		if title and len(title):
			painter.setPen(QPen(QColor(255,255,255)))
			painter.setFont(QFont("Helvetica",24))
			painter.drawText(p.rect(), Qt.WordBreak | Qt.AlignCenter, title)
			painter.setFont(QFont("Helvetica",8))
			painter.drawText(p.rect().bottomLeft() + QPoint(2,-2), "Made with Lphoto")
		return p.convertToImage()
		
	def __findFileLength(self, filePath):
		import backtick
		try:
			lines = backtick.backtick4("ffmpeg -i '%s'"%(filePath))
		except RuntimeError, data:
			pass
		pattern = re.compile(r"Duration:\s+(\d+):(\d+):(\d+).(\d),", re.MULTILINE)
		m = pattern.search(lines)
		l = 0
		if m:
	##~ 		print lines
	##~ 		print m.group(1),m.group(2),m.group(3),m.group(4)
			l = int(m.group(1))*60*60+int(m.group(2))*60+int(m.group(3))
			if int(m.group(4)) > 0:
				l = l + 1	
				
		return l
		
	def __concatenateFile(self, dstPath, srcPath, reps):
		of = open(dstPath, 'wb')
	##~ 	in_file = open(srcPath, 'rb')
		for i in xrange(reps):
			print "CAT FILE",i,"times"
			of.write(open(srcPath, 'rb').read())
		of.close()	
		
	if __name__ == "__main__":
		import sys
		import CDR		# cleanup dir
		
##~ 		findFileLength("/root/sound1.mp3")
##~ 		concatenateFile("/root/sound2.mp3", "/root/sound1.mp3", 5)
##~ 	

	
##~ 	dir = "/root/temp"
##~ 
##~ 	print "################### FIND DEVICE"
##~ 	d = CDR.getBurnerDevices()[0]
##~ 	print "################### INIT DEVICE"
##~ 	
##~ 	def printProgress(c, t):
##~ 		print "Progress",c,t
##~ 
##~ 	l = [(i18n("Encoding Frames..."), lambda : LffmpegProcess(dir, format)),
##~ 		 (i18n("Building VCD Image..."), lambda : LmkvcdfsProcess(dir)),
##~ 		 (i18n("Burning VCD Disc..."), lambda : LcdrdaoProcess(d, dir))
##~ 		]
##~ 			
##~ 	q = LProcessQueue(l)
##~ 	
##~ 	QObject.connect(q, PYSIGNAL("status"), printProgress)
##~ 	QObject.connect(q, PYSIGNAL("abort"), a.quit)
##~ 	QObject.connect(q, PYSIGNAL("complete"), a.quit)
##~ 	
##~ 	q.run()
##~ 	
##~ 	a = QApplication(sys.argv)
##~ 	a.exec_loop()
##~ 	print "Complete."
