""" XSL Template Script

	Template modules need to support the construct function
	Builds and HTML page from a photo list and an XSL template and copies other resouce files to 
	destination path.
"""
import os, shutil, qtxml

def construct(templateDir, exportDir, photos, title):
	""" construct called by LPhoto
	templateDir: path to template and associated resources
	exportDir: path to destination directory.  images should already exist there, with subdir "thumbs" containing thumbnails
	photos: list of dictionaries containing attributes for each photo
	title: title for photo ablum
	"""
	
	xslTemplate = os.path.join(templateDir, "template.xsl")

	# create index.html
	xml = __getXMLFromDict(photos, "Thumbs", title)
	__xslXform(xml, xslTemplate, os.path.join(exportDir, "index.html"))	
	# create a page for each photo
	for i in xrange(len(photos)):
		dict = photos[i]

		(path, filename) = os.path.split(dict['ImagePath'])
		p = i > 0 and os.path.split(photos[i-1]['ImagePath'])[1] or None  # i>0?path:None 
		n = i+1 < len(photos) and os.path.split(photos[i+1]['ImagePath'])[1] or None
		
		xml = __getXMLFromDict([dict], "Photo", prev=p, next=n)
		photoHTML = os.path.join(exportDir, "p_"+filename+".html")
		
		# call xsl
		__xslXform(xml, xslTemplate, photoHTML)	
		
	# copy contents of resources to exportDir
	__copyTreeAll(os.path.join(templateDir, "resources"), os.path.join(exportDir, "resources"))
	
		
#private functionsleft
def __xmlAtom(doc,parent,tag,text):
	obj = doc.createElement(tag)
	parent.appendChild(obj)
	obj.appendChild(doc.createTextNode(str(text)))
		
def __getXMLFromDict(dicts, wrapper="Thumbs", title="My Photos", prev=None, next=None):
	doc = qtxml.QDomDocument(wrapper)
	root = doc.createElement(wrapper)
	root.setAttribute('version','1.0')
	root.setAttribute('Title',title)
	doc.appendChild(root)
	for dict in dicts:
		element = doc.createElement('Photo')
		root.appendChild(element)
		(path, filename) = os.path.split(dict['ImagePath'])
		__xmlAtom(doc, element, "Filename", filename)
		__xmlAtom(doc, element, "Title", dict.get('Caption'))
		__xmlAtom(doc, element, "Rating", dict.get('Rating'))
		__xmlAtom(doc, element, "Comments", dict.get('Comments'))
		# get filename of previous item
		if prev:
			__xmlAtom(doc, element, "Prev", prev)
		# get filename of next item
		if next:
			__xmlAtom(doc, element, "Next", next)

	return str(doc.toString())

def __xslXform(xmlString, templatePath, outputPath):
##~ 		libxsltmod.translate_to_file('f', templatePath, 's', xmlString, outputPath, None)
	tmpEnv = os.environ.get('TMP','/tmp')
	tmpPath = os.path.join(tmpEnv, "lphototmp.xml")
	ouf = open(tmpPath, mode="w")
	ouf.write(xmlString)
	ouf.close()
	os.system("xsltproc -o \"%s\" \"%s\" \"%s\"" % (outputPath, templatePath, tmpPath))

def __copyTreeAll(src, dst):
    names = os.listdir(src)
    if not os.path.isdir(dst):
        os.mkdir(dst)
    for name in names:
        srcname = os.path.join(src, name)
        dstname = os.path.join(dst, name)
        if os.path.isdir(srcname):
            __copyTreeAll(srcname, dstname)
        else:
            shutil.copy2(srcname, dstname)

if __name__=="__main__":
	print "Lphoto XSL template script"


	


