# Copyright (C) 2008-2010 LottaNZB Development Team
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

from lottanzb.core import App
from lottanzb.util import _

class Mode:
    title = ""
    short = ""
    description = ""
    icon = None
    disconnect_message = _("The connection to the HellaNZB daemon has been "
        "lost unexpectedly.")
    
    def __init__(self, config):
        self.config = config
        self.init_error = ""
    
    def enter(self):
        App().backend.connectToHella(*self.get_connection_args())
        
        self.init_error = ""
    
    def leave(self):
        App().backend.disconnectFromHella()
    
    def __str__(self):
        return self.short
    
    def get_connection_args(self):
        raise NotImplementedError
    
    @classmethod
    def get_name(cls):
        return cls.__module__.split(".")[-1]
