/* Copyright (C) 2000-2003 Markus Lausser (sgop@users.sf.net)
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifndef _BUFFER_H_
#define _BUFFER_H_

typedef struct _buffer_t buffer_t;

buffer_t* buffer_new(int size);
int buffer_consume(buffer_t* buffer, int how_many);
void buffer_clear(buffer_t* buffer);
int buffer_consume_virt(buffer_t* buffer, int how_many);
void buffer_destroy(buffer_t* buffer);
int buffer_resize(buffer_t* buffer, int by);
char* buffer_need_space(buffer_t* buffer, int size);

#endif
