/* Copyright (C) 2000/2001 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

char *get_search_string(char *str);

resume_t *resume_new();
void resume_destroy(resume_t * resume);
void resume_load(char *fname, int import);
void resume_save();

void resume_insert_file(resume_t * resume, file_t * file);

resume_t *resume_search_short_file(char *filename);
resume_t *resume_search_long_file(char *filename);
resume_t *resume_search_file(file_t * file);
GList *resume_search_size(unsigned long size);
void resume_search(resume_t * resume, int ping);
void resume_search_all(int force);
void resume_remove_search(resume_t * resume);

void resume_show(resume_t * resume, int where);
void resume_hide(resume_t * resume);
void resume_update(resume_t * resume);
void resume_update_resume2(resume_t * resume);
void resume_cancel(resume_t * resume);
void resume_remove(resume_t * resume);
void resume_freeze(resume_t * resume);
void resume_thaw(resume_t * resume);
void resume_dont_search(resume_t* resume);
void resume_allow_search(resume_t* resume);

int resume_has_potentials(resume_t* resume);
GtkCTree* resume_belongs_to(resume_t * resume);
time_t resume_time_of_death(resume_t* resume);
void resume_remove_outdated();

int resume_timer(gpointer data);

void resume_user_online(char *user, int link);
void resume_user_offline(char *user);

GtkWidget* create_abort_win (void);
