/* Copyright (C) 2000/2001 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <strings.h>
#include <stdlib.h>
#include <getopt.h>
#include <unistd.h>
#include <sys/time.h>
#include <time.h>
#include <stdio.h>
#include <netdb.h>

#include <gtk/gtk.h>

#include "lopster.h"
#include "support.h"
#include "global.h"
#include "splash.h"
#include "interface.h"
#include "chat.h"

struct option long_options[] = {
  {"help", 0, 0, 0},
  {"dir", 1, 0, 0},
  {"config", 1, 0, 0},
  {"away", 1, 0, 0},
  {"no-splash", 0, 0, 0},
  {"version", 0, 0, 0},
  {0, 0, 0, 0}
};

int splash;

void display_usage(void)
{
  fprintf(stderr,
	  _("\nUsage: lopster [options]\n\n"
	    "Options:\n"
	    "--------\n\n"
	    "-h, --help                   Display this text and exit.\n"
	    "-d, --dir                    Use other config folder than (default: $HOME/.lopster)\n"
	    "-c, --config                 Use other rc-file than (default: lopsterrc in config folder)\n"
	    "                             Use with CAUTION!!\n"
	    "-a, --away                   Start Lopster in afk mode\n"
	    "-n, --no-splash              Start Lopster without splash screen\n"
	    "-v, --version                Print version number and exit.\n\n"));
  exit(0);
}

void parse_cmd_line(int argc, char **argv)
{
  gint c, o;

  while ((c = getopt_long(argc, argv, "hd:c:a:nv", long_options, &o)) != -1) {
    switch (c) {
    case 0:
      switch (o) {
      case 0:
	display_usage();
	break;
      case 1:
	if (optarg)
	  global.options.config_dir = strdup(optarg);
	break;
      case 2:
	if (optarg)
	  global.options.config_file = strdup(optarg);
	break;
      case 3:
	if (optarg) {
	  global.afk.message = strdup(optarg);
	  global.afk.since = time(NULL);
	}
	break;
      case 4:
	splash = 0;
	break;
      case 5:
	printf("Lopster %s\n", VERSION);
	exit(0);
	break;
      }
      break;
    case 'h':
      display_usage();
      break;
    case 'd':
      if (optarg)
	global.options.config_dir = strdup(optarg);
      break;
    case 'c':
      if (optarg)
	global.options.config_file = strdup(optarg);
      break;
    case 'a':
      if (optarg) {
	global.afk.message = strdup(optarg);
	global.afk.since = time(NULL);
      }
      break;
    case 'n':
      splash = 0;
      break;
    case 'v':
      printf("Lopster %s\n", VERSION);
      exit(0);
      break;
    }
  }
}

int main(int argc, char *argv[])
{

#ifdef ENABLE_NLS
  bindtextdomain(PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain(PACKAGE);
#endif

  splash = 1;

  gtk_set_locale();
  gtk_init(&argc, &argv);

  add_pixmap_directory(PACKAGE_DATA_DIR "/pixmaps");
  add_pixmap_directory(PACKAGE_SOURCE_DIR "/pixmaps");

  setup_global_vars();
  parse_cmd_line(argc, argv);

  if (splash) global.splash_win = splash_screen();
  else global.splash_win = NULL;

  advance_progress(_("Starting Lopster"), 0.05);
  global.win = create_window();

  // dont really show it, only add it to queue
  gtk_my_widget_show(global.win);
  gtk_widget_realize(global.win);

  while (gtk_events_pending())
    gtk_main_iteration();
  //  gdk_window_raise (global.splash_win->window);
  //  gtk_window_set_transient_for (GTK_WINDOW(global.splash_win), GTK_WINDOW(global.win));

  advance_progress(_("Initializing..."), 0.10);
  global_init();
  advance_progress(_("Initialization done."), 1);

  if (global.afk.message) set_afk(global.afk.message);

  if (global.splash_win) {
    gtk_widget_destroy(global.splash_win);
    global.splash_win = NULL;
  }

  // now show all windows in queue
  gtk_my_widget_show_all();

  gtk_main();
  return 0;
}
