/* Copyright (C) 2000/2001 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#include <sys/types.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/time.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <strings.h>
#include <string.h>
#include <sys/stat.h>

#include "lopster.h"
#include "callbacks.h"
#include "support.h"
#include "interface.h"
#include "connection.h"
#include "global.h"
#include "scheme.h"
#include "log.h"

log_t *search_log_in_list2(char *name)
{
  GList *dlist;
  log_t *log;

  for (dlist = global.logs; dlist; dlist = dlist->next) {
    log = dlist->data;
    if (!l_strcasecmp(name, log->filename))
      return log;
  }
  return NULL;
}

log_t *search_log_in_list(char *des, int type)
{
  GList *dlist;
  log_t *log;
  char str[512];

  for (dlist = global.logs; dlist; dlist = dlist->next) {
    log = dlist->data;
    if (!l_strcasecmp(des, log->description) && (type == log->type)) {
      if (global.options.log_expire &&
	  (global.current_time - log->time > global.options.log_expire * 60 * 60)) {
	fprintf(log->fd, "===========================================\n");
	fprintf(log->fd, " Lopster session: %s", ctime(&global.current_time));
	fprintf(log->fd, "===========================================\n");
	fflush(log->fd);
	log->time = global.current_time;
      }
      return log;
    }
  }

  log = l_malloc(sizeof(log_t));
  if (type == LOG_CHANNEL) {
    sprintf(str, "%s/log/%s.channel", global.options.config_dir, des);
  } else if (type == LOG_PRIVATE) {
    sprintf(str, "%s/log/%s.priv", global.options.config_dir, des);
  } else {
    sprintf(str, "%s/log/%s.log", global.options.config_dir, des);
  }
  log->fd = fopen(str, "a+");
  log->filename = l_strdup(str);
  log->description = l_strdup(des);
  log->type = type;
  log->time = global.current_time;
  global.logs = g_list_append(global.logs, log);

  if (log->fd) {
    strcpy(str, ctime(&global.current_time));
    fprintf(log->fd, "===========================================\n");
    fprintf(log->fd, " Lopster session: %s", ctime(&global.current_time));
    fprintf(log->fd, "===========================================\n");
    fflush(log->fd);
  }
  return log;
}

void log(char *des, int type, const char *fmt, ...)
{
  va_list ap;
  log_t *log;
  char stime[200];

  if (!global.options.logging)
    return;
  // do not log protocol
  //  if (!l_strcasecmp("protocol", des)) return;

  log = search_log_in_list(des, type);
  if (!log || (log->fd == NULL)) return;

  fprintf(log->fd, current_time(stime, TIME_HOUR_MIN_SEC));
  va_start(ap, fmt);
  vfprintf(log->fd, fmt, ap);
  fflush(log->fd);
  va_end(ap);
}

void log_bin(char *des, int type, char* data, int length, int timestamp) {
  log_t *log;
  char stime[200];

  if (!global.options.logging)
    return;
  // do not log protocol
  //  if (!l_strcasecmp("protocol", des)) return;

  log = search_log_in_list(des, type);
  if (!log || (log->fd == NULL)) return;

  if (timestamp) fprintf(log->fd, current_time(stime, TIME_HOUR_MIN_SEC));
  fwrite(data, length, sizeof(char), log->fd);
}

void destroy_log_row(gpointer data)
{
  log_t *log;

  log = (log_t *) data;

  if (log->filename)
    l_free(log->filename);
  if (log->description)
    l_free(log->description);
  if (log->fd)
    fclose(log->fd);
  l_free(log);
}

void log_remove_log(GtkWidget * wid, int row)
{
  GtkCList *clist;
  GtkText *text;

  clist = GTK_CLIST(lookup_widget(wid, "clist14"));
  gtk_clist_clear(clist);

  text = GTK_TEXT(lookup_widget(GTK_WIDGET(wid), "text16"));
  gtk_text_freeze(text);
  gtk_text_set_point(text, 0);
  gtk_text_forward_delete(text, gtk_text_get_length(text));
  gtk_text_thaw(text);

  clist = GTK_CLIST(lookup_widget(wid, "clist15"));
  gtk_clist_remove(clist, row);
}

void log_show_type(GtkWidget * wid, int type)
{
  log_t *log;
  DIR *dir;
  struct dirent *entry;
  char name[2048];
  char *filename;
  int row;
  GtkCList *clist;

  clist = GTK_CLIST(lookup_widget(wid, "clist15"));

  strcpy(name, global.options.config_dir);
  strcat(name, "/log/");
  filename = name + strlen(name);

  if ((dir = opendir(name)) == NULL) {
    printf(_("could not open logdir\n"));
    return;
  }
  while ((entry = readdir(dir)) != NULL) {
    if (entry->d_name[0] == '.')
      continue;

    if ((type == LOG_CHANNEL) &&
	strcmp(&(entry->d_name[strlen(entry->d_name) - 8]), ".channel"))
      continue;
    if ((type == LOG_PRIVATE) &&
	strcmp(&(entry->d_name[strlen(entry->d_name) - 5]), ".priv"))
      continue;
    if ((type == LOG_OTHER) &&
	strcmp(&(entry->d_name[strlen(entry->d_name) - 4]), ".log"))
      continue;

    strcpy(filename, entry->d_name);
    log = (log_t *) l_malloc(sizeof(log_t));
    log->filename = l_strdup(name);
    log->description = l_strdup(filename);
    log->fd = NULL;
    log->type = type;
    strcpy(tstr[0], log->description);
    row = gtk_clist_append(clist, list);
    gtk_clist_set_row_data_full(clist, row, (gpointer) log,
				destroy_log_row);
  }
}

void log_hide_type(GtkWidget * wid, int type)
{
  GtkCList *clist;
  log_t *log;
  int i1;

  clist = GTK_CLIST(lookup_widget(wid, "clist15"));
  i1 = 0;
  while (i1 < clist->rows) {
    log = (log_t *) gtk_clist_get_row_data(clist, i1);
    if (!log) {
      printf("should not happen");
      i1++;
      continue;
    }
    if (log->type == type) {
      log_remove_log(wid, i1);
    } else {
      i1++;
    }
  }
}

void log_show_init()
{
  GtkWidget *win;
  GtkText *text;
  GtkWidget *temp;

  win = create_log_win();
  text = GTK_TEXT(lookup_widget(win, "text16"));
  gtk_text_set_word_wrap(text, 1);
  gtk_widget_set_style(GTK_WIDGET(text), global.style[2]);
  temp = lookup_widget(win, "label525");
  gtk_widget_set_style(temp, global.style[3]);

  gtk_widget_show(win);
}

void log_show_file(GtkCList * clist, int num)
{
  GtkText *text;
  log_t *log;
  char line[2048];
  int row;
  long file_pos;
  int number;

  log = (log_t *) gtk_clist_get_row_data(clist, num);
  if (log->fd == NULL) {
    if ((log->fd = fopen(log->filename, "r")) == NULL) {
      printf(_("could not open [%s]\n"), log->filename);
      return;
    }
  } else {
    rewind(log->fd);
  }

  clist = GTK_CLIST(lookup_widget(GTK_WIDGET(clist), "clist14"));
  gtk_clist_freeze(clist);
  gtk_clist_clear(clist);

  text = GTK_TEXT(lookup_widget(GTK_WIDGET(clist), "text16"));
  gtk_text_freeze(text);
  gtk_text_set_point(text, 0);
  gtk_text_forward_delete(text, gtk_text_get_length(text));
  gtk_text_thaw(text);

  file_pos = 0;
  number = 0;
  row = 0;
  file_pos = ftell(log->fd);
  while (fgets(line, 2047, log->fd)) {
    if (line[0] == '=') {
      file_pos = ftell(log->fd) - strlen(line);
    } else if (!strncmp(line, " Lopster session: ", 18)) {
      if (number < 1)
	gtk_clist_remove(clist, row);
      number = 0;
      strcpy(tstr[0], line + 18);
      row = gtk_clist_append(clist, list);
      gtk_clist_set_row_data(clist, row, (gpointer) file_pos);
    } else {
      number++;
    }
  }
  if (number < 1)
    gtk_clist_remove(clist, row);
  gtk_clist_thaw(clist);
}

void log_show_section(GtkCList * clist, int num)
{
  GtkCList *clist2;
  log_t *log;
  GList *row_list;
  int row;

  char line[2048];
  char str[2048];
  char *pos;
  char *pos2;
  GtkWidget *temp;
  long file_pos;
  int number;
  int is_new;

  clist2 = GTK_CLIST(lookup_widget(GTK_WIDGET(clist), "clist15"));
  row_list = clist2->selection;
  if (row_list)
    row = (int) row_list->data;
  else {
    printf("no row selected\n");
    return;
  }
  log = (log_t *) gtk_clist_get_row_data(clist2, row);
  if (log->fd == NULL) {
    printf("no log pointer\n");
    return;
  }
  temp = lookup_widget(GTK_WIDGET(clist), "text16");
  gtk_text_freeze(GTK_TEXT(temp));
  gtk_text_set_point(GTK_TEXT(temp), 0);
  gtk_text_forward_delete(GTK_TEXT(temp),
			  gtk_text_get_length(GTK_TEXT(temp)));

  file_pos = (long) gtk_clist_get_row_data(clist, num);
  fseek(log->fd, file_pos, SEEK_SET);

  number = 0;
  while (fgets(line, 2047, log->fd)) {
    number++;
    if (line[0] == '=') {
      if (number > 3)
	break;
      text_print_colored(temp, global.scheme, "message", line);
    } else if (!strncmp(line, " Lopster session: ", 18)) {
      text_print_colored(temp, global.scheme, "message", line);
    } else {
      is_new = 0;
      pos2 = line;
      if (*pos2 == '<')
	pos = strchr(pos2, '>');
      else if (*pos2 == '[') {
	pos = strchr(pos2, ']');
	is_new = 1;
      } else if (*pos2 == '(')
	pos = strchr(pos2, ')');
      else
	pos = strchr(pos2, ' ');

      if (!pos) {
	text_print_colored(temp, global.scheme, "text", pos2);
	continue;
      } else
	pos++;
      strncpy(str, pos2, pos - pos2);
      str[pos - pos2] = 0;
      if (!is_new) {
	text_print_colored(temp, global.scheme, "user", str);
	text_print_colored(temp, global.scheme, "text", pos);
	continue;
      }

      text_print_colored(temp, global.scheme, "message", str);

      if (*pos)
	pos2 = pos + 1;
      else
	pos2 = pos;

      if (*pos2 == '<')
	pos2 = strchr(pos2, '>');
      else if (*pos2 == '[')
	pos2 = strchr(pos2, ']');
      else if (*pos2 == '(')
	pos2 = strchr(pos2, ')');
      else
	pos2 = strchr(pos2, ' ');

      if (!pos2) {
	text_print_colored(temp, global.scheme, "text", pos);
	continue;
      } else
	pos2++;

      strncpy(str, pos, pos2 - pos);
      str[pos2 - pos] = 0;

      text_print_colored(temp, global.scheme, "user", str);
      text_print_colored(temp, global.scheme, "text", pos2);
    }
  }
  gtk_text_thaw(GTK_TEXT(temp));
}

void log_delete(GtkWidget * wid, int row)
{
  GtkCList *clist;
  log_t *log;

  clist = GTK_CLIST(lookup_widget(wid, "clist15"));
  log = (log_t *) gtk_clist_get_row_data(clist, row);
  if (!log) {
    printf("no log pointer\n");
    return;
  }
  unlink(log->filename);

  log = search_log_in_list2(log->filename);
  log_remove_log(wid, row);

  if (log) {
    destroy_log_row(log);
    global.logs = g_list_remove(global.logs, log);
  }
}
