/* Copyright (C) 2000/2001 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#define O_NONE            0
#define O_WINDOW          1
#define O_CHANNEL         2
#define O_PRIVATE         3
#define O_OPERATOR        4
#define O_GLOBAL          5
#define O_WALLOP          6

typedef struct _exec_t exec_t;

struct _exec_t
{
  int input;
  int fd;
  char *command;
  int output;
  char *who;
  char buf[2048];
  int pos;
  int id;
  int pid;
};

exec_t *exec_new(char *name);
void exec_destroy(exec_t * exec);
void exec_command(char *data);
gint get_exec_input(gpointer data, gint source,
		    GdkInputCondition condition);
void exec_print_line(exec_t * exec, char *line);
void exec_kill_all();
