/* LogJam, a GTK LiveJournal client.
 * Copyright (C) 2000-2002 Evan Martin <evan@livejournal.com>
 * vim:ts=4:sw=4:
 *
 * $Id: convert.c,v 1.1 2002/01/29 04:51:25 martine Exp $
 */

#include <string.h>

#include "convert.h"

static unsigned char
koi_win[] = {128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
	     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
	     160,161,162,184,186,165,179,191,168,169,170,171,172,180,174,175,
	     176,177,178,168,170,181,178,175,184,185,170,187,188,165,190,169,
	     254,224,225,246,228,229,244,227,245,232,233,234,235,236,237,238,
	     239,255,240,241,242,243,230,226,252,251,231,248,253,249,247,250,
	     222,192,193,214,196,197,212,195,213,200,201,202,203,204,205,206,
	     207,223,208,209,210,211,198,194,220,219,199,216,221,217,215,218};

static unsigned char
win_koi[] = {128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
	     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
	     160,161,162,163,164,189,166,167,179,191,180,171,172,173,174,183,
	     176,177,182,166,173,181,182,183,163,185,164,187,188,189,190,167,
	     225,226,247,231,228,229,246,250,233,234,235,236,237,238,239,240,
	     242,243,244,245,230,232,227,254,251,253,255,249,248,252,224,241,
	     193,194,215,199,196,197,214,218,201,202,203,204,205,206,207,208,
	     210,211,212,213,198,200,195,222,219,221,223,217,216,220,192,209};

void koi2win (char *str) {
	int len = strlen(str), i = 0;
	unsigned char c;

	for (i = 0; i < len; i++) {
		c = str[i]; str[i] = ( (c < 128) ? c : koi_win[(c & 0xFF) - 128]);
	}
}

void win2koi (char *str) {
	int len = strlen(str), i;
	unsigned char c;

	for (i = 0; i < len; i++) {
		c = str[i]; str[i] = ( (c < 128) ? c : win_koi[(c & 0xFF) - 128]);
	}
}
