/* LogJam, a GTK LiveJournal client.
 * Copyright (C) 2000,2001 Evan Martin <evan@livejournal.com>
 * vim:ts=4:sw=4:
 *
 * $Id: spawn.c,v 1.2 2001/07/14 05:56:16 martine Exp $
 */

#include <glib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>

#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>

#include "spawn.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#ifdef HAVE_GNOME
#include <gnome.h>
#endif /* HAVE_GNOME */

char *halfgnome_spawn_commands[] = {
	"netscape -remote 'openURL(%s, new-window)' || netscape %s",
	"gnome-moz-remote --newwin %s",
	NULL
};

static char *spawn_command = NULL;

void halfgnome_spawn_set_command(char *cmd) {
	if (spawn_command) g_free(spawn_command);
	spawn_command = g_strdup(cmd);
	/* this will leak, but only one string on program exit... */
}

char* halfgnome_spawn_get_command() {
	return spawn_command;
}

#ifndef HAVE_GNOME
static int execcmd(char *cmd) {
	char *argv[5];
	int argc;
	argc = 0;

	fprintf(stderr, "spawning %s...\n", cmd);
	argv[argc++] = "/bin/sh";
	argv[argc++] = "-c";
	argv[argc++] = cmd;
	argv[argc] = NULL;

	return execv("/bin/sh", argv);
}

static void spawn_url(char *url) {
	pid_t pid;

	if (spawn_command == NULL) return;

	pid = fork();
	if (pid < 0) {
		perror("fork");
		return;
	} else if (pid == 0) { /* child */
		char cmd[2000];

		/* and now, another hack because I don't know how many %s's
		 * are in spawn_command. :( */
#define ARGS_HACK url,url,url,url,url,url
		sprintf(cmd, spawn_command, ARGS_HACK);
		/* we don't care about the memory leak... it is just passed on to
		 * the child.  an array would cause the same problem!  */
		if (execcmd(cmd) < 0) {
			perror("exec");
		}
		/* never gets here, unless /bin/sh is bad. */

		_exit(0);
	}
}
#endif /* HAVE_GNOME */

void halfgnome_spawn_url(char *url) {
#ifdef HAVE_GNOME
	gnome_url_show(url);
#else
	if (spawn_command == NULL)
		spawn_command = g_strdup(halfgnome_spawn_commands[0]);
	spawn_url(url);
#endif
}


