/*
 * Copyright 2003,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "controlfilter.h"

using namespace log4cxx;
using namespace log4cxx::helpers;

ControlFilter::ControlFilter()
{
}

String ControlFilter::filter(const String& in) const throw(UnexpectedFormatException)
{
	int len = allowedPatterns.size();

	for (int i = 0; i < len; i++)
	{
		if (match(allowedPatterns[i], in))
		{
			return in;
		}
	}

	throw UnexpectedFormatException(String(_T("[")) + in + _T("]"));
}

ControlFilter& ControlFilter::operator<<(const String& allowedPattern)
{
	allowedPatterns.push_back(allowedPattern);
	return *this;
}

