#include "slider.h"

#include <string>

using namespace std;

Slider::Slider(AppletWindowParams params, int dist):Applet(params), slide_dist(dist){
    for (int i=0; i<4; ++i)
	actions[i] = "";
}

void Slider::AddAction(SlideDir dir, AppAction action){
    actions[dir] = action;
}

string Slider::OnMousePress(int x, int y){
    pressx = x;
    pressy = y;
    return "";
}

Slider::SlideDir Slider::slide_dir(int px, int py, int kx, int ky){
    const int dist = slide_dist;
    int w = kx-px;
    int h = ky-py;
    if (w*w + h*h < dist*dist)
	return Slider::NO_SLIDE;
    if (w>0 && w>abs(h))
	return Slider::SLIDE_E;
    if (h>0 && h>abs(w))
	return Slider::SLIDE_S;
    if (abs(w) > abs(h))
	return Slider::SLIDE_W;
    return Slider::SLIDE_N;
}


AppAction Slider::OnMouseRelease(int x, int y){
    SlideDir dir = slide_dir(pressx, pressy, x, y);
    if (dir == NO_SLIDE){
	win.UnmapInput();
	win.GetDisplay().GenMouseClickEvent(win.PosX() + x, win.PosY() + y, 1);
	win.MapInput();
    }
    return actions[dir];
}


