#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#ifndef WIN32
#include <unistd.h>
#endif

#include "listargate.h"

void lsg_baseform(const char *lsgmode)
{
   printf("<form action=\"%s\" method=POST>\n", LMAPI->get_string("lsg-cgi-url"));
   printf("<input type=hidden name=\"user\" value=\"%s\">\n", 
      LMAPI->get_string("user"));
   printf("<input type=hidden name=\"lsg-mode\" value=\"%s\">\n",
      lsgmode);
}

void lsg_header(const char *title)
{
   printf("Content-type: text/html\n\n");
   printf("<!-- Listargate v%s\n", LISTARGATE_VERSION);
   printf("  -- \n");
   printf("  -- Listar Mailing List Manager WWW Interface\n");
   printf("  -- Written by Rachel Blackman (sparks@noderunner.net)\n");
   printf("  -->\n\n");
   printf("<TITLE>LISTARGATE: %s</TITLE>\n", title);
   printf("<BODY bgcolor=#ffffff text=#000000 link=#0000ff vlink=#aa00aa>\n");
   printf("<font size=+3>LISTARGATE</font><HR>\n");
   printf("<font face=\"Verdana, Arial, Helvetica\">\n");
}

void lsg_footer()
{
   printf("</font><HR><font size=-1>");
   printf("LISTARGATE %s: Listar WWW Interface\n", LISTARGATE_VERSION);
   printf("</font>\n");
}

void lsg_frontpage()
{
   lsg_header("User Login");

   printf("<font size=+2><b>Listargate Login</b></font><P>\n");

   printf("<table border=0>\n");
   printf("<tr><td>&nbsp;</td>\n");
   printf("<td rowspan=2 valign=top>\n");
   printf("Listargate is a WWW interface to the Listar mailing list package.\n");
   printf("It allows users and admins to perform tasks on a list through ");
   printf("a user-friendly interface.\n");
   printf("</td></tr>\n");

   printf("<tr><td>\n");
   printf("<form action=\"%s\" method=\"post\">\n", LMAPI->get_string("lsg-cgi-url"));
   printf("<input type=hidden name=\"lsg-mode\" value=\"mainmenu\">\n");
   printf("<b>E-mail Address:</b>\n");
   printf("<input type=text name=user size=64><BR>\n");
   printf("<input type=submit value=\"Log In\">\n");
   printf("</form>\n");
   printf("</td></tr></table>\n");
   
   lsg_footer();
}

void lsg_mainmenu()
{
   char dname[BIG_BUF];
   struct list_user user;
   int status;

   lsg_header("Main Menu");

   printf("<font size=+2><b>Main Menu</b></font><P>\n");

   printf("<table border=0 cellspacing=5>\n");
   printf("<tr><td valign=top><b>Current user:</b> %s<BR></td>\n", 
       LMAPI->get_string("user"));
   printf("<td width=20%%>&nbsp;</td>\n");
   printf("<td valign=top rowspan=2>\n");
   printf("<form action=\"%s\" method=POST>\n",
       LMAPI->get_string("lsg-cgi-url"));
   printf("<input type=hidden name=\"lsg-mode\" value=\"listmenu\">\n");
   printf("<input type=hidden name=\"user\" value=\"%s\">\n",
       LMAPI->get_string("user"));
   printf("<b>List:</b> \n");
   printf("<select name=\"lsg-list\" size=1>\n");

   if (!(status = LMAPI->walk_lists(&dname[0]))) {
       printf("<option value=\"uhoh\">-- Unable to access lists --\n");
   } else {
       while (status) {
          if(LMAPI->list_valid(dname)) {
              LMAPI->clean_var("advertise", VAR_TEMP);
              LMAPI->read_conf_parm(dname,"advertise", VAR_TEMP);
              if (LMAPI->user_find_list(dname,LMAPI->get_string("user"),&user)) {
                 printf("\t<option value=\"%s\"> %s (Subscribed)\n",
                   dname, dname);
              } else {
                 if (LMAPI->get_bool("advertise")) {
                    printf("\t<option value=\"%s\"> %s\n", dname, dname);
                 }
              }
              LMAPI->clean_var("advertise", VAR_TEMP);
          }
          status = LMAPI->next_lists(&dname[0]);
       }
   }
   printf("</select>\n");
   printf("<input type=submit value=\"Access List\"></form><P>\n");
   printf("Only lists that you are subscribed to, or which are set to \n");
   printf("be publically advertised will be displayed in the above list.\n");
   printf("</td></tr>\n");
   printf("<tr><td valign=bottom>\n");

   lsg_baseform("frontpage");
   printf("<input type=submit value=\"Log out\">\n");
   printf("</form>\n");

   printf("</td><td>&nbsp;</td>\n");
   printf("</table>\n");

   lsg_footer();
}

void lsg_parse(const char *sfile)
{
   FILE *tfile;

   if ((tfile = LMAPI->open_file(sfile,"r")) == NULL) {
      return;
   }
   LMAPI->close_file(tfile);

   LMAPI->read_conf(sfile, VAR_TEMP);

   if (!LMAPI->get_var("lsg-mode") || !LMAPI->get_var("user")) {
      lsg_frontpage();
   } else {
      if(!strcasecmp(LMAPI->get_string("lsg-mode"),"mainmenu")) {
          lsg_mainmenu();
      } else
      if(!strcasecmp(LMAPI->get_string("lsg-mode"),"listmenu")) {
          lsg_listmenu();
      } else
      if(!strcasecmp(LMAPI->get_string("lsg-mode"),"unsubscribe")) {
          lsg_unsubscribe();
      } else 
      if(!strcasecmp(LMAPI->get_string("lsg-mode"),"subscribe")) {
          lsg_subscribe();
      } else
      if(!strcasecmp(LMAPI->get_string("lsg-mode"),"listintro")) {
          lsg_showintro();
      } else
      if(!strcasecmp(LMAPI->get_string("lsg-mode"),"listfaq")) {
          lsg_showfaq();
      } else
      if(!strcasecmp(LMAPI->get_string("lsg-mode"),"listinfo")) {
          lsg_showinfo();
      } else
      if(!strcasecmp(LMAPI->get_string("lsg-mode"),"listusers")) {
          lsg_showusers();
      } else
      if(!strcasecmp(LMAPI->get_string("lsg-mode"),"flagedit")) {
          lsg_flagedit();
      } else
      {
          lsg_frontpage();
      }
   }

   LMAPI->unlink_file(sfile);
}
