#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "listargate.h"

struct LPMAPI *LMAPI;

MODE_HANDLER(mode_listargate)
{
   LMAPI->log_printf(1,"LISTARGATE Mode\n");
   lsg_parse(LMAPI->get_string("lsg-file"));

   return MODE_OK;
}

CMDARG_HANDLER(cmdarg_lsg)
{
   LMAPI->log_printf(1,"LISTARGATE CmdArg\n");
   LMAPI->set_var("lsg-file",argv[0],VAR_GLOBAL);
   LMAPI->set_var("mode","listargate", VAR_GLOBAL);
   LMAPI->set_var("fakequeue","yes",VAR_GLOBAL);

   return CMDARG_OK;
}

void listargate_switch_context(void)
{
   LMAPI->log_printf(15, "Switching context in module ListarGate\n");
}

int listargate_upgradelist(int prev, int cur)
{
   LMAPI->log_printf(10, "Upgrading lists in module ListarGate\n");
   return 1;
}

int listargate_upgrade(int prev, int cur)
{
   LMAPI->log_printf(10, "Upgrading module ListarGate\n");
   return 1;
}

void listargate_init(void)
{
   LMAPI->log_printf(10, "Initializing module ListarGate\n");
}

void listargate_unload(void)
{
   LMAPI->log_printf(10, "Unloading module ListarGate\n");
}

void listargate_load(struct LPMAPI *api)
{
   LMAPI = api;
 
   LMAPI->log_printf(10, "Loading module ListarGate\n");
   LMAPI->add_module("Listargate", "Listar WWW Interface");
   LMAPI->add_cmdarg("-lsg", 1, "<lsg-path-and-file>", cmdarg_lsg);
   LMAPI->add_mode("listargate", mode_listargate);

   /* Variable registration */
   LMAPI->register_var("lsg-cgi-url", "", "CGI",
                       "URL to the CGI script for the web interface.",
                       "lsg-cgi-url = http://www.mydom.com/listserver",
                       VAR_STRING, VAR_ALL);
   LMAPI->register_var("lsg-file", NULL, NULL, NULL, NULL, VAR_STRING,
                       VAR_INTERNAL|VAR_GLOBAL);
   LMAPI->register_var("user", NULL, NULL, NULL, NULL, VAR_STRING,
                       VAR_INTERNAL|VAR_TEMP);
   LMAPI->register_var("lsg-mode", NULL, NULL, NULL, NULL, VAR_STRING,
                       VAR_INTERNAL|VAR_TEMP);
   LMAPI->register_var("lsg-list", NULL, NULL, NULL, NULL, VAR_STRING,
                       VAR_INTERNAL|VAR_TEMP);
}
