package Lire::Extensions::WWW::RobotSchema;

# vim:syntax=perl

use strict;

use vars qw( $VERSION @ISA );

use Lire::AsciiDlf::ExtendedFieldsCreator;

use Lire::WWW::Domain;
use Lire::WWW::UserAgent;

use Carp;

BEGIN {
    ($VERSION)	= '$Revision: 1.2 $' =~ m!Revision: ([.\d]+)!;
    @ISA = qw( Lire::AsciiDlf::ExtendedFieldsCreator );
}

sub init_computation {
    my ( $self ) = @_;

    $self->{domain_analyzer} = new Lire::WWW::Domain;
    $self->{ua_analyzer}     = new Lire::WWW::UserAgent;

    # Cache the field's index of requested_page
    $self->{useragent_idx}  = $self->schema->field( "useragent" )->pos;
    $self->{domain_idx} = $self->schema->field( "client_domain" )->pos;
}

sub create_extended_fields {
    my ( $self, $dlf ) = @_;

    my $domain = $dlf->[$self->{domain_idx} ];
    my $ua     = $dlf->[$self->{useragent_idx} ];
    # make sure data is available and in hostname format (not IP)
    if ( ($domain eq "LIRE_NOTAVAIL") && ( $ua eq 'LIRE_NOTAVAIL' ) ) {
	return ["LIRE_NOTAVAIL" ];
    } else {
	if ( $domain ne 'LIRE_NOTAVAIL' ) {
	    $self->{domain_analyzer}->setDomain($domain);
	    my $robot = $self->{domain_analyzer}->getRobot();
	    return [ $robot ] if $robot !~ /Unknown/;
	}
	if ( $ua ne "LIRE_NOTAVAIL" ) {
	    $self->{ua_analyzer}->setUserAgent($ua);
	    return [ $self->{ua_analyzer}->getRobot() ];
	}
	return [ "Unknown" ];
    }
}

# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::Extensions::WWW::RobotSchema -

=head1 SYNOPSIS

=head1 DESCRIPTION

Interface to the Lire::WWW::Domain and Lire::WWW::UserAgent package.

=head1 VERSION

$Id: RobotSchema.pm,v 1.2 2002/01/19 18:20:06 vanbaal Exp $

=head1 COPYRIGHT

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

E.L. Willighagen <egonw@logreport.org>

=cut
