package Lire::Extensions::WWW::DirSchema;

# vim:syntax=perl

use strict;

use vars qw( $VERSION @ISA );

use Lire::AsciiDlf::ExtendedFieldsCreator;

use Carp;

BEGIN {
    ($VERSION)	= '$Revision: 1.2 $' =~ m!Revision: ([.\d]+)!;
    @ISA = qw( Lire::AsciiDlf::ExtendedFieldsCreator );
}


sub init_computation {
    my ( $self ) = @_;

    # Cache the index of requested_page
    $self->{requested_file_idx} =
      $self->schema->field( "requested_file" )->pos;
}

sub create_extended_fields {
    my ( $self, $dlf ) = @_;

    my $dir = $dlf->[$self->{requested_file_idx}];
    $dir =~ s|/[^/]*$||;
    $dir ||= '/';

    [$dir];
}

# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::DirSchema -

=head1 SYNOPSIS


=head1 DESCRIPTION

=head1 VERSION

$Id: DirSchema.pm,v 1.2 2001/10/18 19:13:22 flacoste Exp $

=head1 COPYRIGHT

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=cut
