<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:lire="http://www.logreport.org/LRML/"
  exclude-result-prefixes="lire">

  <!-- Day stats mode templates -->

  <xsl:template match="lire:subreport[@superservice = 'www' and @type = 'bytes-by-day']" mode="date_stat-mode">
    <xsl:for-each select="lire:table/lire:entry">

      <xsl:variable name="day"	 select="lire:name"/>
      <xsl:variable name="bytes" select="lire:value"/>
      <xsl:variable name="hits"
	select="ancestor::lire:report/lire:subreport[@superservice = 'www' and @type =
	'requests-by-day']/lire:table/lire:entry[lire:name = $day]/lire:value"/>

      <dayStat day="{$day}" bytes="{$bytes}" hits="{$hits}"/>
    </xsl:for-each>
  </xsl:template>

  <!-- Graph mode templates -->

  <xsl:template match="lire:subreport[@superservice = 'www' and
    @type='top-referer-page-connections']" mode="graph-mode">
    <xsl:call-template name="table2graph"/>
  </xsl:template>

  <!-- Summary mode templates -->

  <xsl:template match="lire:subreport[@superservice = 'www' and
    @type='requests-by-result']" mode="summary-mode">
    <xsl:for-each select="lire:table/lire:entry">
      <httpCode code="{lire:name}" total_count="{lire:value}"/>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="lire:subreport[@superservice = 'www' and
    @type='requests-by-method']" mode="summary-mode">
    <xsl:for-each select="lire:table/lire:entry">
      <httpMethod name="{lire:name}" total_count="{lire:value}"/>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="lire:subreport[@superservice= 'www' and
    @type='requests-by-version']" mode="summary-mode">
    <xsl:for-each select="lire:table/lire:entry">
      <httpVersion name="{lire:name}" total_count="{lire:value}"/>
    </xsl:for-each>
  </xsl:template>

  <!-- Directories mode templates -->
  <xsl:template match="lire:subreport[@superservice = 'www' and 
    @type='bytes-by-dir']" mode="directories-mode">
    <xsl:for-each select="lire:table/lire:entry">
      <directory name="{lire:name}" bytes="{lire:value}"/>
    </xsl:for-each>
  </xsl:template>
  
</xsl:stylesheet>
<!-- 
Keep this comment at the end of the file
Local variables:
mode: xml
sgml-indent-step: 2
End:
-->
