package tests::ConfigDlfSchemaSpecTest;

use strict;

use tests::ConfigSpecTest;

use base qw/tests::ConfigSelectSpecTest/;

use Lire::DlfSchema;
use Lire::Test::Mock;

sub set_up {
    my $self = $_[0];

    $self->tests::ConfigScalarSpecTest::set_up();

    $self->{'cfg'}{'lr_schemas_path'} = [];
    $self->{'_old_schemas'} = \%Lire::DlfSchema::SCHEMA_CACHE;
    %Lire::DlfSchema::SCHEMA_CACHE =
      ( 'super1' => 
        new Lire::Test::Mock( 'Lire::DlfSchema',
                              'id' => 'super1', 'superservice' => 'super1',
                              'title' => 'Super 1',
                              'description' => '<para>Super 1</para>' ),
        'super2' => 
        new Lire::Test::Mock( 'Lire::DlfSchema',
                              'id' => 'super2', 'superservice' => 'super2',
                              'title' => 'Super 2',
                              'description' => '<para>Super 2</para>' ),
        'super1-ext' => 
        new Lire::Test::Mock( 'Lire::ExtendedSchema',
                              'id' => 'super1-ext', 'superservice' => 'super1',
                              'title' => 'Super 1 Extended',
                              'description' => '<para>Super 1 Extended</para>' ),
        'another_one' => 
        new Lire::Test::Mock( 'Lire::DlfSchema',
                              'id' => 'another_one',
                              'superservice' => 'another_one',
                              'title' => 'Another One',
                              'description' => '<para>Another One</para>' ), 
        );

    return;
}

sub tear_down {
    my $self = $_[0];

    $self->tests::ConfigScalarSpecTest::tear_down();

    *Lire::DlfSchema::SCHEMA_CACHE = $self->{'_old_schemas'};

    return;
}

sub type {
    return "Lire::Config::DlfSchemaSpec";
}

sub normalize_test_data {
    return (
            'super1' => "super1",
            'Super1' => undef,
           );
}

sub valid_test_data {
    return qw/ super1 super1-ext super2 /;
}

sub invalid_test_data {
    return qw/ super4 /;
}

sub test_add {
    my $self = $_[0];

    $self->assert_dies( qr/Lire::Config::DlfSchemaSpec cannot contain any components/,
                        sub { $self->{'spec'}->add() } );
}

sub test_new {
    my $self = $_[0];
    $self->SUPER::test_new();

    $self->assert_null( $self->{'spec'}{'_superservices'} );
    my $spec = new Lire::Config::DlfSchemaSpec( 'name' => 'test',
                                                'superservices' => 1 );
    $self->assert_num_equals( 1, $spec->{'_superservices'} );
    $self->assert_num_equals( 1, $spec->superservices() );
}

sub test_normalize {
    my $self = $_[0];

    $self->SUPER::test_normalize();
}

sub test_is_valid {
    my $self = $_[0];

    $self->SUPER::test_is_valid();
}

sub test_options {
    my $self = $_[0];

    my @options = $self->{'spec'}->options();

    $self->assert_num_equals( 4, scalar( @options ) );
    $self->assert_isa( 'Lire::Config::OptionSpec', $options[0] );
    $self->assert_deep_equals( [ 'another_one', 'super1', 'super1-ext',
                                 'super2' ],
                               [ map { $_->name() } @options ] );

    $self->assert_str_equals( 'Another One', $options[0]->summary() );
    $self->assert_str_equals( '<para>Another One</para>',
                              $options[0]->description() );

    $self->{'spec'}->superservices( 1 );
    $self->assert_deep_equals( [ 'another_one', 'super1', 'super2' ],
                               [ map { $_->name() } $self->{'spec'}->options() ] );
}

1;
