package tests::UIReportConfigListWidgetTest;

use strict;

use base qw/ Lire::Test::TestCase /;

use Lire::Config::TypeSpec;
use Lire::Test::CursesUIDriver;
use Lire::UI::ReportConfigListWidget;
use Lire::ReportConfig;
use Curses::UI;

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->{'driver'} = new Lire::Test::CursesUIDriver();
    $self->{'driver'}->setup_curses_ui();

    $self->{'ui'} = new Curses::UI();
    $self->{'driver'}->set_curses_ui( $self->{'ui'} );
    $self->{'window'} = $self->{'ui'}->add( 'window', 'Window' );

    $self->{'_old_templates'} = \%Lire::ReportConfig::TEMPLATES;

    my $spec = new Lire::Config::ListSpec( 'name' => 'reports' );
    $spec->add( new Lire::Config::ReportSpec( 'name' => 'report' ) );

    $self->{'ftp_default'} =
      new Lire::Config::ReportSpec( 'name' => 'ftp_default' )->instance();
    $self->{'www_default'} =
      new Lire::Config::ReportSpec( 'name' => 'www_default' )->instance();
    *Lire::ReportConfig::TEMPLATES =
      { 'ftp_default' => $self->{'ftp_default'},
        'www_default' => $self->{'www_default'},
      };
    $self->{'ftp_default'}->get( 'id' )->set( 'ftp_default' );
    $self->{'www_default'}->get( 'id' )->set( 'www_default' );

    $self->{'cfg'}{'lr_templates_path'} = [];
    $self->{'reports'} = $spec->instance();

    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    *Lire::ReportConfig::TEMPLATES = $self->{'_old_templates'};
    $self->{'driver'}->teardown_curses_ui();

    return;
}

sub test_update_type_popupmenu {
    my $self = $_[0];

    my $widget = $self->{'window'}->add( 'list_widget',
                                         'Lire::UI::ReportConfigListWidget',
                                         'value' => $self->{'reports'} );
    $self->assert_isa( 'Lire::UI::ReportConfigListWidget', $widget );
    $self->assert_deep_equals( [ 'ftp_default', 'www_default' ],
                               $widget->getobj( 'type_widget' )->{'-values'} );
    $self->assert_deep_equals( {},
                               $widget->getobj( 'type_widget' )->{'-labels'} );
}

sub test_new_value {
    my $self = $_[0];

    my $widget = $self->{'window'}->add( 'list_widget',
                                         'Lire::UI::ReportConfigListWidget',
                                         'value' => $self->{'reports'} );
    my $popup = $widget->getobj( 'type_widget' );
    $self->assert_null( $widget->new_value(), 'new_value() != undef' );

    $popup->{'-selected'} = 0;
    my $value = $widget->new_value();
    $self->assert_isa( 'Lire::Config::Object', $value );
    $self->assert_str_not_equals( $self->{'ftp_default'}, $value );
    $self->assert_str_equals( 'ftp_default', $value->get( 'id' )->get() );
    $self->assert_str_equals( $self->{'reports'}->spec()->get( 'report' ),
                              $value->spec() );

    $popup->{'-selected'} = 1;
    $value = $widget->new_value();
    $self->assert_str_equals( 'www_default', $value->get( 'id' )->get() );
}

1;
